/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity;

import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.openhft.affinity.Affinity;
import net.openhft.affinity.AffinityLock;
import net.openhft.affinity.AffinityStrategy;
import net.openhft.affinity.CpuLayout;
import net.openhft.affinity.LockCheck;
import net.openhft.affinity.impl.NullAffinity;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LockInventory {
    private static final Logger LOGGER = LoggerFactory.getLogger(LockInventory.class);
    private final NavigableMap<Integer, AffinityLock[]> physicalCoreLocks = new TreeMap<Integer, AffinityLock[]>();
    private CpuLayout cpuLayout;
    private AffinityLock[] logicalCoreLocks;

    public LockInventory(CpuLayout cpuLayout) {
        this.set(cpuLayout);
    }

    public static String dumpLocks(@NotNull AffinityLock[] locks) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < locks.length; ++i) {
            AffinityLock al = locks[i];
            sb.append(i).append(": ");
            sb.append(al.toString());
            sb.append('\n');
        }
        return sb.toString();
    }

    private static boolean anyStrategyMatches(int cpuOne, int cpuTwo, AffinityStrategy[] strategies) {
        for (AffinityStrategy strategy : strategies) {
            if (!strategy.matches(cpuOne, cpuTwo)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAnyCpu(int cpuId) {
        return cpuId == -1;
    }

    private static boolean updateLockForCurrentThread(boolean bind, AffinityLock al, boolean wholeCore) throws ClosedByInterruptException {
        try {
            if (LockCheck.updateCpu(al.cpuId())) {
                al.assignCurrentThread(bind, wholeCore);
                return true;
            }
        }
        catch (ClosedByInterruptException e) {
            throw e;
        }
        catch (IOException e) {
            LOGGER.warn("Error occurred acquiring lock", e);
        }
        return false;
    }

    public final synchronized CpuLayout getCpuLayout() {
        return this.cpuLayout;
    }

    public final synchronized void set(CpuLayout cpuLayout) {
        if (cpuLayout.equals(this.cpuLayout)) {
            return;
        }
        this.reset(cpuLayout);
        for (int i = 0; i < cpuLayout.cpus(); ++i) {
            boolean base = AffinityLock.BASE_AFFINITY.get(i);
            boolean reservable = AffinityLock.RESERVED_AFFINITY.get(i);
            LOGGER.trace("cpu {} base={} reservable= {}", i, base, reservable);
            AffinityLock lock = this.logicalCoreLocks[i] = this.newLock(i, base, reservable);
            int layoutId = lock.cpuId();
            int physicalCore = this.toPhysicalCore(layoutId);
            AffinityLock[] locks = (AffinityLock[])this.physicalCoreLocks.get(physicalCore);
            if (locks == null) {
                locks = new AffinityLock[cpuLayout.threadsPerCore()];
                this.physicalCoreLocks.put(physicalCore, locks);
            }
            locks[cpuLayout.threadId((int)layoutId)] = lock;
        }
    }

    public final synchronized AffinityLock acquireLock(boolean bind, int cpuId, AffinityStrategy ... strategies) {
        if (Affinity.getAffinityImpl() instanceof NullAffinity) {
            return this.noLock();
        }
        boolean specificCpuRequested = !LockInventory.isAnyCpu(cpuId);
        try {
            if (specificCpuRequested && cpuId != 0) {
                if (cpuId > this.logicalCoreLocks.length) {
                    LOGGER.warn("Unable to acquire lock on CPU {} for thread {}, as not enough CPUs", (Object)cpuId, (Object)Thread.currentThread());
                    return this.noLock();
                }
                AffinityLock required = this.logicalCoreLocks[cpuId];
                if (required.canReserve(true) && LockInventory.anyStrategyMatches(cpuId, cpuId, strategies) && LockInventory.updateLockForCurrentThread(bind, required, false)) {
                    return required;
                }
                LOGGER.warn("Unable to acquire lock on CPU {} for thread {}, trying to find another CPU", (Object)cpuId, (Object)Thread.currentThread());
            }
            for (AffinityStrategy strategy : strategies) {
                for (int i = this.logicalCoreLocks.length - 1; i > 0; --i) {
                    AffinityLock al = this.logicalCoreLocks[i];
                    if (!al.canReserve(false) || !LockInventory.isAnyCpu(cpuId) && !strategy.matches(cpuId, al.cpuId()) || !LockInventory.updateLockForCurrentThread(bind, al, false)) continue;
                    return al;
                }
            }
        }
        catch (ClosedByInterruptException e) {
            Thread.currentThread().interrupt();
            return this.noLock();
        }
        LOGGER.warn("No reservable CPU for {}", (Object)Thread.currentThread());
        return this.noLock();
    }

    public final synchronized AffinityLock tryAcquireLock(boolean bind, int cpuId) {
        if (Affinity.getAffinityImpl() instanceof NullAffinity) {
            return null;
        }
        if (cpuId > this.logicalCoreLocks.length) {
            return null;
        }
        AffinityLock required = this.logicalCoreLocks[cpuId];
        try {
            if (required.canReserve(true) && LockInventory.updateLockForCurrentThread(bind, required, false)) {
                return required;
            }
        }
        catch (ClosedByInterruptException e) {
            Thread.currentThread().interrupt();
            return this.noLock();
        }
        LOGGER.warn("Unable to acquire lock on CPU {} for thread {}, trying to find another CPU", (Object)cpuId, (Object)Thread.currentThread());
        return null;
    }

    public final synchronized AffinityLock acquireCore(boolean bind, int cpuId, AffinityStrategy ... strategies) {
        for (AffinityStrategy strategy : strategies) {
            Iterator iterator = this.physicalCoreLocks.descendingMap().values().iterator();
            block3: while (iterator.hasNext()) {
                AffinityLock[] als;
                for (AffinityLock al : als = (AffinityLock[])iterator.next()) {
                    if (!al.canReserve(false) || !strategy.matches(cpuId, al.cpuId())) continue block3;
                }
                AffinityLock al = als[0];
                try {
                    if (!LockInventory.updateLockForCurrentThread(bind, al, true)) continue;
                    return al;
                }
                catch (ClosedByInterruptException e) {
                    Thread.currentThread().interrupt();
                    return this.noLock();
                }
            }
        }
        LOGGER.warn("No reservable Core for {}", (Object)Thread.currentThread());
        return this.acquireLock(bind, cpuId, strategies);
    }

    public final synchronized void bindWholeCore(int logicalCoreID) {
        if (logicalCoreID < 0) {
            LOGGER.warn("Can't bind core since it was not possible to reserve it!");
            return;
        }
        int core = this.toPhysicalCore(logicalCoreID);
        for (AffinityLock al : (AffinityLock[])this.physicalCoreLocks.get(core)) {
            if (al.isBound() && al.assignedThread != null && al.assignedThread.isAlive()) {
                LOGGER.warn("cpu {} already bound to {}", (Object)al.cpuId(), (Object)al.assignedThread);
                continue;
            }
            al.bound = true;
            al.assignedThread = Thread.currentThread();
        }
        if (LOGGER.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder().append("Assigning core ").append(core);
            String sep = ": cpus ";
            for (AffinityLock al : (AffinityLock[])this.physicalCoreLocks.get(core)) {
                sb.append(sep).append(al.cpuId());
                sep = ", ";
            }
            sb.append(" to ").append(Thread.currentThread());
            LOGGER.info(sb.toString());
        }
    }

    public final synchronized void release(boolean resetAffinity) {
        Thread t = Thread.currentThread();
        for (AffinityLock al : this.logicalCoreLocks) {
            Thread at = al.assignedThread;
            if (at == t) {
                this.releaseAffinityLock(t, al, "Releasing cpu {} from {}");
                continue;
            }
            if (at == null || at.isAlive()) continue;
            this.releaseAffinityLock(t, al, "Releasing cpu {} from {} as it is not alive.");
        }
        if (resetAffinity) {
            Affinity.resetToBaseAffinity();
        }
    }

    public final synchronized String dumpLocks() {
        return LockInventory.dumpLocks(this.logicalCoreLocks);
    }

    protected AffinityLock newLock(int cpuId, boolean base, boolean reservable) {
        return new AffinityLock(cpuId, base, reservable, this);
    }

    private void reset(CpuLayout cpuLayout) {
        this.cpuLayout = cpuLayout;
        this.logicalCoreLocks = new AffinityLock[cpuLayout.cpus()];
        this.physicalCoreLocks.clear();
    }

    private int toPhysicalCore(int layoutId) {
        return this.cpuLayout.socketId(layoutId) * this.cpuLayout.coresPerSocket() + this.cpuLayout.coreId(layoutId);
    }

    private void releaseAffinityLock(Thread t, AffinityLock al, String format) {
        LOGGER.info(format, (Object)al.cpuId(), (Object)t);
        al.assignedThread = null;
        al.bound = false;
        al.boundHere = null;
        LockCheck.releaseLock(al.cpuId());
    }

    public AffinityLock noLock() {
        return this.newLock(-1, false, false);
    }
}

