/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class Bootstrap {
    public static final String OS_ARCH = System.getProperty("os.arch", "?");
    public static final String VM_VENDOR = System.getProperty("java.vm.vendor", "?");
    public static final String VM_VERSION = System.getProperty("java.vm.version", "?");
    public static final String VM_NAME = System.getProperty("java.vm.name", "?");
    public static final boolean IS_64BIT = Bootstrap.is64bit0();
    public static final boolean IS_AZUL_ZING = Bootstrap.isAzulZing0();
    public static final boolean IS_AZUL_ZULU = Bootstrap.isAzulZulu0();
    public static final boolean ASSERT_ENABLED;
    public static final String PROC_SELF = "/proc/self";
    public static final int PROCESS_ID;
    static final int JVM_JAVA_MAJOR_VERSION;
    static final boolean IS_JAVA_9_PLUS;
    static final boolean IS_JAVA_12_PLUS;
    static final boolean IS_JAVA_14_PLUS;
    static final boolean IS_JAVA_15_PLUS;
    static final boolean IS_JAVA_19_PLUS;
    static final boolean IS_JAVA_20_PLUS;
    static final boolean IS_JAVA_21_PLUS;
    private static final String OS_NAME;
    private static final String LOWER_OS_NAME;
    public static final boolean IS_WIN10;
    public static final boolean IS_WIN;
    public static final boolean IS_MAC;
    public static final boolean IS_ARM;
    public static final boolean IS_MAC_ARM;
    public static final boolean IS_LINUX;

    private Bootstrap() {
    }

    public static boolean isArm0() {
        return Boolean.parseBoolean(System.getProperty("jvm.isarm")) || OS_ARCH.startsWith("arm") || OS_ARCH.startsWith("aarch") || Bootstrap.isMacArm0();
    }

    public static boolean isMacArm0() {
        return IS_MAC && !OS_ARCH.equals("x86_64");
    }

    public static boolean isAzulZing0() {
        return VM_VENDOR.startsWith("Azul ") && VM_VERSION.contains("zing");
    }

    public static boolean isAzulZulu0() {
        return VM_VENDOR.startsWith("Azul ") && (VM_NAME.startsWith("OpenJDK ") || VM_NAME.startsWith("Zulu"));
    }

    public static int getJvmJavaMajorVersion() {
        return JVM_JAVA_MAJOR_VERSION;
    }

    public static boolean isJava9Plus() {
        return IS_JAVA_9_PLUS;
    }

    public static boolean isJava12Plus() {
        return IS_JAVA_12_PLUS;
    }

    public static boolean isJava14Plus() {
        return IS_JAVA_14_PLUS;
    }

    public static boolean isJava15Plus() {
        return IS_JAVA_15_PLUS;
    }

    public static boolean isJava19Plus() {
        return IS_JAVA_19_PLUS;
    }

    public static boolean isJava20Plus() {
        return IS_JAVA_20_PLUS;
    }

    public static boolean isJava21Plus() {
        return IS_JAVA_21_PLUS;
    }

    private static int getMajorVersion0() {
        try {
            Method method = Runtime.class.getDeclaredMethod("version", new Class[0]);
            Object version = method.invoke((Object)Runtime.getRuntime(), new Object[0]);
            Class<?> clz = Class.forName("java.lang.Runtime$Version");
            return (Integer)clz.getDeclaredMethod("major", new Class[0]).invoke(version, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException method) {
            try {
                return Integer.parseInt(Runtime.class.getPackage().getSpecificationVersion().split("\\.")[1]);
            }
            catch (Exception e) {
                System.err.println("Unable to get the major version, defaulting to 8 " + e);
                return 8;
            }
        }
    }

    public static boolean is64bit0() {
        String systemProp = System.getProperty("com.ibm.vm.bitmode");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("sun.arch.data.model");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("java.vm.version");
        return systemProp != null && systemProp.contains("_64");
    }

    private static int getProcessId0() {
        String pid = null;
        File self = new File(PROC_SELF);
        try {
            if (self.exists()) {
                pid = self.getCanonicalFile().getName();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (pid == null) {
            pid = ManagementFactory.getRuntimeMXBean().getName().split("@", 0)[0];
        }
        if (pid != null) {
            try {
                return Integer.parseInt(pid);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int rpid = 1;
        System.err.println(Bootstrap.class.getName() + ": Unable to determine PID, picked 1 as a PID");
        return rpid;
    }

    static {
        PROCESS_ID = Bootstrap.getProcessId0();
        OS_NAME = System.getProperty("os.name");
        LOWER_OS_NAME = OS_NAME.toLowerCase();
        IS_WIN10 = LOWER_OS_NAME.equals("windows 10");
        IS_WIN = LOWER_OS_NAME.startsWith("win");
        IS_MAC = LOWER_OS_NAME.contains("mac");
        IS_ARM = Bootstrap.isArm0();
        IS_MAC_ARM = Bootstrap.isMacArm0();
        IS_LINUX = LOWER_OS_NAME.startsWith("linux");
        JVM_JAVA_MAJOR_VERSION = Bootstrap.getMajorVersion0();
        IS_JAVA_9_PLUS = JVM_JAVA_MAJOR_VERSION >= 9;
        IS_JAVA_12_PLUS = JVM_JAVA_MAJOR_VERSION >= 12;
        IS_JAVA_14_PLUS = JVM_JAVA_MAJOR_VERSION >= 14;
        IS_JAVA_15_PLUS = JVM_JAVA_MAJOR_VERSION >= 15;
        IS_JAVA_19_PLUS = JVM_JAVA_MAJOR_VERSION >= 19;
        IS_JAVA_20_PLUS = JVM_JAVA_MAJOR_VERSION >= 20;
        IS_JAVA_21_PLUS = JVM_JAVA_MAJOR_VERSION >= 21;
        boolean assertEnabled = false;
        if (!$assertionsDisabled) {
            assertEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        ASSERT_ENABLED = assertEnabled;
    }
}

