/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.TimingPauser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LongPauser
implements Pauser,
TimingPauser {
    private static final String SHOW_PAUSES = Jvm.getProperty("pauses.show");
    private final long minPauseTimeNS;
    private final long maxPauseTimeNS;
    private final AtomicBoolean pausing = new AtomicBoolean();
    private final long minBusyNS;
    private final long minYieldNS;
    private long firstPauseNS = Long.MAX_VALUE;
    private long pauseTimeNS;
    private long timePaused = 0L;
    private long countPaused = 0L;
    @Nullable
    private volatile Thread thread = null;
    private long yieldStart = 0L;
    private long pauseUntilNS = 0L;

    public LongPauser(int minBusy, int minYield, long minTime, long maxTime, @NotNull TimeUnit timeUnit) {
        this.minBusyNS = timeUnit.toNanos(minBusy);
        this.minYieldNS = timeUnit.toNanos(minYield);
        this.minPauseTimeNS = timeUnit.toNanos(minTime);
        this.maxPauseTimeNS = timeUnit.toNanos(maxTime);
        this.pauseTimeNS = this.minPauseTimeNS;
    }

    @Override
    public void reset() {
        if (this.yieldStart > 0L) {
            this.checkYieldTime();
            ++this.countPaused;
        }
        this.pauseTimeNS = this.minPauseTimeNS;
        this.pauseUntilNS = 0L;
        if (SHOW_PAUSES != null && this.firstPauseNS < Long.MAX_VALUE) {
            this.showPauses();
        }
        this.firstPauseNS = Long.MAX_VALUE;
    }

    @Override
    public void pause() {
        try {
            this.pause(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    @Override
    public void asyncPause() {
        this.pauseUntilNS = System.nanoTime() + this.pauseTimeNS;
        this.increasePauseTimeNS();
    }

    @Override
    public boolean asyncPausing() {
        return this.pauseUntilNS > System.nanoTime();
    }

    private void showPauses() {
        String name = Thread.currentThread().getName();
        if (name.startsWith(SHOW_PAUSES)) {
            Jvm.perf().on(this.getClass(), " paused for " + (double)(System.nanoTime() - this.firstPauseNS) / 1000000.0 + " ms.");
        }
    }

    @Override
    public void pause(long timeout, @NotNull TimeUnit timeUnit) throws TimeoutException {
        ++this.countPaused;
        long now = System.nanoTime();
        if (this.firstPauseNS == Long.MAX_VALUE) {
            this.firstPauseNS = now;
        }
        if (now < this.firstPauseNS + this.minBusyNS) {
            Jvm.nanoPause();
            return;
        }
        if (now < this.firstPauseNS + this.minYieldNS) {
            this.yield();
            return;
        }
        if (timeout < Long.MAX_VALUE && this.firstPauseNS + timeUnit.toNanos(timeout) - now < 0L) {
            throw new TimeoutException();
        }
        this.checkYieldTime();
        this.doPause(this.pauseTimeNS);
        this.increasePauseTimeNS();
    }

    private void increasePauseTimeNS() {
        this.pauseTimeNS = Math.min(this.maxPauseTimeNS, this.pauseTimeNS + (this.pauseTimeNS >> 6) + 10000L);
    }

    private void checkYieldTime() {
        if (this.yieldStart > 0L) {
            long time = System.nanoTime() - this.yieldStart;
            this.timePaused += time;
            this.yieldStart = 0L;
        }
    }

    private void yield() {
        if (this.yieldStart == 0L) {
            this.yieldStart = System.nanoTime();
        }
        Thread.yield();
    }

    void doPause(long delayNs) {
        long start = System.nanoTime();
        this.thread = Thread.currentThread();
        this.pausing.set(true);
        if (!this.thread.isInterrupted()) {
            LockSupport.parkNanos(delayNs);
        }
        this.pausing.set(false);
        long time = System.nanoTime() - start;
        this.timePaused += time;
    }

    @Override
    public void unpause() {
        Thread threadSnapshot = this.thread;
        if (threadSnapshot != null && this.pausing.get()) {
            LockSupport.unpark(threadSnapshot);
        }
    }

    @Override
    public long timePaused() {
        return this.timePaused / 1000000L;
    }

    @Override
    public long countPaused() {
        return this.countPaused;
    }
}

