/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.openhft.chronicle.core.Jvm;
import org.jetbrains.annotations.NotNull;

public final class ReflectionUtil {
    private static final boolean PREPEND_PACKAGE = Jvm.getBoolean("wire.method.prependPackage");
    private static final String PACKAGE_PREFIX = "net.openhft.chronicle.wire.method";

    private ReflectionUtil() {
    }

    public static List<Class<?>> interfaces(@NotNull Class<?> oClass) {
        ArrayList list = new ArrayList();
        ReflectionUtil.interfaces(oClass, list);
        return list;
    }

    private static void interfaces(Class<?> oClass, List<Class<?>> list) {
        Class<?> baseClass = oClass.getSuperclass();
        if (baseClass == null) {
            return;
        }
        list.addAll(Arrays.asList(oClass.getInterfaces()));
        ReflectionUtil.interfaces(baseClass, list);
    }

    @NotNull
    public static String generatedPackageName(String classFullName) {
        int lastDot = classFullName.lastIndexOf(46);
        if (lastDot != -1) {
            String packageName = classFullName.substring(0, lastDot);
            if (PREPEND_PACKAGE || classFullName.startsWith("java.") || classFullName.startsWith("javax.") || classFullName.startsWith("com.sun.")) {
                return "net.openhft.chronicle.wire.method." + packageName;
            }
            return packageName;
        }
        return PREPEND_PACKAGE ? PACKAGE_PREFIX : "";
    }
}

