/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.internal;

import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.DocumentContextHolder;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.MarshallableOutBuilder;
import net.openhft.chronicle.wire.QueryWire;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;

public class FileMarshallableOut
implements MarshallableOut {
    private final URL url;
    private final FMOOptions options = new FMOOptions();
    private Wire wire;
    private final DocumentContextHolder dcHolder = new DocumentContextHolder(){

        @Override
        public void close() {
            if (this.chainedElement()) {
                return;
            }
            super.close();
            if (FileMarshallableOut.this.wire.bytes().isEmpty()) {
                return;
            }
            String path = FileMarshallableOut.this.url.getPath();
            String path0 = ((FileMarshallableOut)FileMarshallableOut.this).options.append ? path : path + ".tmp";
            try (FileOutputStream out = new FileOutputStream(path0, ((FileMarshallableOut)FileMarshallableOut.this).options.append);){
                Bytes<?> bytes = FileMarshallableOut.this.wire.bytes();
                out.write((byte[])bytes.underlyingObject(), 0, (int)bytes.readLimit());
            }
            catch (IOException ioe) {
                throw new IORuntimeException(ioe);
            }
            try {
                if (!((FileMarshallableOut)FileMarshallableOut.this).options.append) {
                    Files.move(Paths.get(path0, new String[0]), Paths.get(path, new String[0]), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                }
            }
            catch (IOException ioe) {
                throw new IORuntimeException(ioe);
            }
            FileMarshallableOut.this.wire.clear();
        }
    };

    public FileMarshallableOut(MarshallableOutBuilder builder, WireType wireType) throws InvalidMarshallableException {
        this.url = builder.url();
        assert (this.url.getProtocol().equals("file"));
        String query = this.url.getQuery();
        if (query != null) {
            QueryWire queryWire = new QueryWire(Bytes.from(query));
            this.options.readMarshallable(queryWire);
        }
        this.wire = (Wire)wireType.apply(Bytes.allocateElasticOnHeap());
    }

    @Override
    public DocumentContext writingDocument(boolean metaData) throws UnrecoverableTimeoutException {
        this.dcHolder.documentContext(this.wire.writingDocument(metaData));
        return this.dcHolder;
    }

    @Override
    public DocumentContext acquireWritingDocument(boolean metaData) throws UnrecoverableTimeoutException {
        this.dcHolder.documentContext(this.wire.acquireWritingDocument(metaData));
        return this.dcHolder;
    }

    static class FMOOptions
    extends SelfDescribingMarshallable {
        boolean append;

        FMOOptions() {
        }
    }
}

