/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.undertow;

import io.undertow.server.handlers.ProxyPeerAddressHandler;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ServletContainerInitializerInfo;
import io.undertow.servlet.api.ServletStackTraces;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.web.SpringServletContainerInitializer;
import org.springframework.web.WebApplicationInitializer;

public interface Deployment {
    public static final String ROOT_PATH = "/";

    public DeploymentInfo configuration();

    public static Deployment springSelfContained(Class<? extends WebApplicationInitializer> ... webAppInitializers) {
        return () -> new DeploymentInfo().setDeploymentName("default").setDisplayName("default").setServletStackTraces(ServletStackTraces.ALL).setContextPath(ROOT_PATH).setClassLoader(Deployment.class.getClassLoader()).setResourceManager((ResourceManager)new ClassPathResourceManager(Deployment.class.getClassLoader())).addServletContainerInitializer(new ServletContainerInitializerInfo(SpringServletContainerInitializer.class, new HashSet<Class>(Arrays.asList(webAppInitializers))));
    }

    public static Deployment springWithExternalWebResources(Path localResources, Class<? extends WebApplicationInitializer> ... webAppInitializers) {
        return () -> Deployment.springSelfContained(webAppInitializers).configuration().setResourceManager((ResourceManager)new FileResourceManager(localResources.toFile()));
    }

    default public Deployment useForwardHeaders() {
        return () -> this.configuration().addInitialHandlerChainWrapper(new ProxyPeerAddressHandler.Builder().build(Collections.emptyMap()));
    }

    default public Deployment withProperties(Map<String, String> properties) {
        return () -> {
            DeploymentInfo info = this.configuration();
            info.getInitParameters().putAll(properties);
            return info;
        };
    }

    default public Deployment withProperties(EnumerablePropertySource propertySource) {
        Map<String, String> properties = Arrays.stream(propertySource.getPropertyNames()).collect(Collectors.toMap(Function.identity(), name -> Objects.toString(propertySource.getProperty(name))));
        return this.withProperties(properties);
    }
}

