/*
 * Decompiled with CFR 0.152.
 */
package conf;

import helpers.cxf.exception.handling.camel.processor.ThrownExceptionMessageToInBodyProcessor;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import net.osgiliath.helpers.cdi.eager.Eager;
import org.apache.camel.Component;
import org.apache.camel.Processor;
import org.apache.camel.component.http.HttpComponent;
import org.apache.camel.component.jackson.JacksonDataFormat;
import org.apache.camel.dataformat.xmljson.XmlJsonDataFormat;
import org.apache.camel.spi.DataFormat;
import org.ops4j.pax.cdi.api.OsgiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Eager
public class Components {
    private Logger LOG = LoggerFactory.getLogger(Components.class);
    @Inject
    @OsgiService(filter="(component-type=jms)", dynamic=true)
    private Component jms;
    @Inject
    @OsgiService(filter="(component-type=jmsXA)", dynamic=true)
    private Component jmsXA;

    @Produces
    @Named(value="thrownExceptionMessageToInBodyProcessor")
    public Processor getThrownExceptionMessageToInBodyProcessor() {
        this.LOG.info("Inject Processor in body");
        return new ThrownExceptionMessageToInBodyProcessor();
    }

    @Produces
    @Named(value="jms")
    public Component getJms() {
        this.LOG.info("Inject jms");
        return this.jms;
    }

    @Produces
    @Named(value="jmsXA")
    public Component getJmsXA() {
        this.LOG.info("Inject jmsXA");
        return this.jmsXA;
    }

    @Produces
    @Named(value="http")
    public Component getHttp() {
        this.LOG.info("Inject httpComponent");
        return new HttpComponent();
    }

    @Produces
    @Named(value="json")
    public DataFormat getJacksonDataFormat() {
        return new JacksonDataFormat();
    }

    @Produces
    @Named(value="xmljson")
    public DataFormat getXmlJsonDataFormat() {
        return new XmlJsonDataFormat();
    }
}

