/*
 * Decompiled with CFR 0.152.
 */
package net.osgiliath.hello.routes;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.bind.JAXBContext;
import net.osgiliath.hello.business.model.Hellos;
import net.osgiliath.hello.model.jpa.model.HelloEntity;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.cdi.ContextName;
import org.apache.camel.component.jackson.JacksonDataFormat;
import org.apache.camel.converter.jaxb.JaxbDataFormat;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.commons.io.IOUtils;

@ContextName
public class HelloRoute
extends RouteBuilder {
    private DataFormat helloObjectJSonFormat = new JacksonDataFormat(HelloEntity.class, Hellos.class);
    @Inject
    @Named(value="thrownExceptionMessageToInBodyProcessor")
    private Processor thrownExceptionMessageToInBodyProcessor;
    @Inject
    @Named(value="xmljson")
    private DataFormat xmljson;

    public void configure() throws Exception {
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{HelloEntity.class, Hellos.class});
        JaxbDataFormat jaxBDataFormat = new JaxbDataFormat(ctx);
        ((ChoiceDefinition)((ChoiceDefinition)((RouteDefinition)this.from("{{hello.MessagingEntryPoint}}").log(LoggingLevel.INFO, "Received message: \"${in.body}\"")).filter(this.header("webSocketMsgType").isNotEqualTo((Object)"heartBeat")).choice().when(this.header("httpRequestType").isEqualTo((Object)"POST")).to("direct:persistObject")).endChoice().otherwise().setBody((Expression)this.simple("{error:  'Command not supported for the JaxRS queue'}"))).to("direct:toError");
        ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:persistObject").setHeader("CamelHttpMethod", (Expression)this.constant("POST"))).setHeader("Content-Type", (Expression)this.constant("application/xml"))).unmarshal(this.helloObjectJSonFormat)).marshal((DataFormat)jaxBDataFormat)).log(LoggingLevel.INFO, "marshalled: ${body}")).doTry().inOnly("{{net.osgiliath.hello.business.url.restservice}}/hello")).to("direct:updateTopic")).doCatch(Exception.class).log(LoggingLevel.WARN, "Exception: " + this.exceptionMessage().toString())).to("direct:helloValidationError")).end();
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:updateTopic").setHeader("CamelHttpMethod", (Expression)this.constant("GET"))).setHeader("Content-Type", (Expression)this.constant("application/xml"))).inOut("{{net.osgiliath.hello.business.url.restservice}}/hello")).inOut("direct:marshall")).to("{{hello.MessagingEndPoint}}");
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:marshall").process(new Processor(){

            public void process(Exchange exchange) throws Exception {
                InputStream bodyObject = (InputStream)exchange.getIn().getBody(InputStream.class);
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)bodyObject, (Writer)writer);
                String theString = writer.toString();
                exchange.getIn().setBody((Object)theString);
            }
        })).log("hello data retrieved from JaxRS : ${in.body}")).marshal(this.xmljson)).log(LoggingLevel.INFO, "marshalled: ${body}");
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:helloValidationError").process(this.thrownExceptionMessageToInBodyProcessor)).process(new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)((String)exchange.getIn().getBody(String.class)).replaceAll("\"", "'").replaceAll("\n", ""));
            }
        })).setBody((Expression)this.simple("{\"error\": \"${body}\"}"))).log("Subscription error: ${body}")).to("{{hello.MessagingErrors}}");
    }

    public void setThrownExceptionMessageToInBodyProcessor(Processor thrownExceptionMessageToInBodyProcessor) {
        this.thrownExceptionMessageToInBodyProcessor = thrownExceptionMessageToInBodyProcessor;
    }
}

