/*
 * Decompiled with CFR 0.152.
 */
import info.bitrich.xchangestream.core.ProductSubscription;
import info.bitrich.xchangestream.core.StreamingExchange;
import info.bitrich.xchangestream.core.StreamingMarketDataService;
import info.bitrich.xchangestream.service.netty.NettyStreamingService;
import io.reactivex.Completable;
import org.knowm.xchange.gateio.GateioExchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GateioStreamingExchange
extends GateioExchange
implements StreamingExchange {
    private static final Logger LOG = LoggerFactory.getLogger(GateioStreamingExchange.class);
    private final String V4_URL = "wss://api.gateio.ws/ws/v4/";
    private GateioStreamingService streamingService;
    private StreamingMarketDataService streamingMarketDataService;

    public Completable connect(ProductSubscription ... args) {
        if (args == null || args.length == 0) {
            throw new UnsupportedOperationException("The ProductSubscription must be defined!");
        }
        this.streamingService = new GateioStreamingService("wss://api.gateio.ws/ws/v4/", this.exchangeSpecification);
        this.applyStreamingSpecification(this.getExchangeSpecification(), (NettyStreamingService)this.streamingService);
        this.streamingMarketDataService = new GateioStreamingMarketDataService(this.streamingService);
        this.streamingService.subscribeMultipleCurrencyPairs(args);
        return this.streamingService.connect();
    }

    public Completable disconnect() {
        GateioStreamingService service = this.streamingService;
        this.streamingService = null;
        this.streamingMarketDataService = null;
        return service.disconnect();
    }

    public StreamingMarketDataService getStreamingMarketDataService() {
        return this.streamingMarketDataService;
    }

    public boolean isAlive() {
        return this.streamingService != null && this.streamingService.isSocketOpen();
    }

    public void useCompressedMessages(boolean compressedMessages) {
        this.streamingService.useCompressedMessages(compressedMessages);
    }
}

