/*
 * Decompiled with CFR 0.152.
 */
import dto.response.GateioOrderBookResponse;
import dto.response.GateioTradesResponse;
import info.bitrich.xchangestream.core.StreamingMarketDataService;
import io.reactivex.Observable;
import java.util.List;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.instrument.Instrument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GateioStreamingMarketDataService
implements StreamingMarketDataService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GateioStreamingMarketDataService.class);
    private final GateioStreamingService service;

    public GateioStreamingMarketDataService(GateioStreamingService service) {
        this.service = service;
    }

    private boolean containsPair(List<Instrument> pairs, CurrencyPair pair) {
        return pairs.stream().anyMatch(p -> p.equals(pair));
    }

    public Observable<OrderBook> getOrderBook(CurrencyPair currencyPair, Object ... args) {
        if (!this.containsPair(this.service.getProduct().getOrderBook(), currencyPair)) {
            throw new UnsupportedOperationException(String.format("The currency pair %s is not subscribed for orderbook", currencyPair));
        }
        return this.service.getRawWebSocketTransactions(currencyPair, "spot.order_book", new Object[0]).map(msg -> ((GateioOrderBookResponse)msg).toOrderBook(currencyPair));
    }

    public Observable<Ticker> getTicker(CurrencyPair currencyPair, Object ... args) {
        throw new NotYetImplementedForExchangeException("Not yet implemented!");
    }

    public Observable<Trade> getTrades(CurrencyPair currencyPair, Object ... args) {
        return this.service.getRawWebSocketTransactions(currencyPair, "spot.trades", new Object[0]).map(msg -> ((GateioTradesResponse)msg).toTrade());
    }
}

