/*
 * Decompiled with CFR 0.152.
 */
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import dto.GateioWebSocketSubscriptionMessage;
import dto.response.GateioOrderBookResponse;
import dto.response.GateioTradesResponse;
import dto.response.GateioWebSocketTransaction;
import info.bitrich.xchangestream.core.ProductSubscription;
import info.bitrich.xchangestream.service.netty.JsonNettyStreamingService;
import info.bitrich.xchangestream.service.netty.StreamingObjectMapperHelper;
import info.bitrich.xchangestream.service.netty.WebSocketClientCompressionAllowClientNoContextAndServerNoContextHandler;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandler;
import io.reactivex.Observable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.currency.CurrencyPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GateioStreamingService
extends JsonNettyStreamingService {
    private static final Logger LOG = LoggerFactory.getLogger(GateioStreamingService.class);
    private static final String SUBSCRIBE = "subscribe";
    private static final String UNSUBSCRIBE = "unsubscribe";
    private static final String CHANNEL_NAME_DELIMITER = "-";
    public static final String SPOT_ORDERBOOK_CHANNEL = "spot.order_book";
    public static final String SPOT_TRADES_CHANNEL = "spot.trades";
    public static final String SPOT_TICKERS_CHANNEL = "spot.tickers";
    private static final int MAX_DEPTH_DEFAULT = 5;
    private static final int UPDATE_INTERVAL_DEFAULT = 100;
    private final String apiUri;
    private ProductSubscription productSubscription;
    private ExchangeSpecification exchangeSpecification;
    private final Map<String, Observable<JsonNode>> subscriptions = new ConcurrentHashMap<String, Observable<JsonNode>>();
    private final Map<String, String> channelSubscriptionMessages = new ConcurrentHashMap<String, String>();

    public GateioStreamingService(String apiUri, ExchangeSpecification exchangeSpecification) {
        super(apiUri, Integer.MAX_VALUE);
        this.apiUri = apiUri;
        this.exchangeSpecification = exchangeSpecification;
    }

    public Observable<GateioWebSocketTransaction> getRawWebSocketTransactions(CurrencyPair currencyPair, String channelName, Object ... args) {
        ObjectMapper mapper = StreamingObjectMapperHelper.getObjectMapper();
        return this.subscribeChannel(channelName, currencyPair, args).map(msg -> {
            switch (channelName) {
                case "spot.order_book": {
                    return (GateioWebSocketTransaction)mapper.treeToValue((TreeNode)msg, GateioOrderBookResponse.class);
                }
                case "spot.trades": {
                    return (GateioWebSocketTransaction)mapper.treeToValue((TreeNode)msg, GateioTradesResponse.class);
                }
            }
            return (GateioWebSocketTransaction)mapper.treeToValue((TreeNode)msg, GateioWebSocketTransaction.class);
        }).filter(t -> currencyPair.equals((Object)t.getCurrencyPair()));
    }

    public void subscribeMultipleCurrencyPairs(ProductSubscription ... products) {
        this.productSubscription = products[0];
    }

    public ProductSubscription getProduct() {
        return this.productSubscription;
    }

    protected String getChannelNameFromMessage(JsonNode message) {
        String channel = message.path("channel") != null ? message.path("channel").asText() : "";
        String currencyPairOrderBook = message.path("result").path("s") != null ? message.path("result").path("s").asText() : "";
        String currencyPairTradesTickers = message.path("result").path("currency_pair") != null ? message.path("result").path("currency_pair").asText() : "";
        return channel + CHANNEL_NAME_DELIMITER + currencyPairOrderBook + currencyPairTradesTickers;
    }

    public Observable<JsonNode> subscribeChannel(String channelName, Object ... args) {
        CurrencyPair currencyPair = args.length > 0 && args[0] instanceof CurrencyPair ? (CurrencyPair)args[0] : null;
        String currencyPairChannelName = String.format("%s-%s", channelName, currencyPair.toString().replace('/', '_'));
        try {
            if (!this.channels.containsKey(currencyPairChannelName) && !this.subscriptions.containsKey(currencyPairChannelName)) {
                this.subscriptions.put(currencyPairChannelName, (Observable<JsonNode>)super.subscribeChannel(currencyPairChannelName, args));
                this.channelSubscriptionMessages.put(currencyPairChannelName, this.getSubscribeMessage(currencyPairChannelName, currencyPair));
            }
        }
        catch (IOException e) {
            LOG.error("Failed to subscribe to channel: {}", (Object)currencyPairChannelName);
        }
        return this.subscriptions.get(currencyPairChannelName);
    }

    public String getSubscribeMessage(String channelName, Object ... args) throws IOException {
        CurrencyPair currencyPair = args.length > 0 && args[0] instanceof CurrencyPair ? (CurrencyPair)args[0] : null;
        int maxDepth = this.exchangeSpecification.getExchangeSpecificParametersItem("maxDepth") != null ? (Integer)this.exchangeSpecification.getExchangeSpecificParametersItem("maxDepth") : 5;
        int msgInterval = this.exchangeSpecification.getExchangeSpecificParametersItem("updateInterval") != null ? (Integer)this.exchangeSpecification.getExchangeSpecificParametersItem("updateInterval") : 100;
        GateioWebSocketSubscriptionMessage subscribeMessage = new GateioWebSocketSubscriptionMessage(channelName.split(CHANNEL_NAME_DELIMITER)[0], SUBSCRIBE, currencyPair, msgInterval, maxDepth);
        return this.objectMapper.writeValueAsString((Object)subscribeMessage);
    }

    protected WebSocketClientExtensionHandler getWebSocketClientExtensionHandler() {
        return WebSocketClientCompressionAllowClientNoContextAndServerNoContextHandler.INSTANCE;
    }

    public String getUnsubscribeMessage(String channelName, Object ... args) throws IOException {
        GateioWebSocketSubscriptionMessage unsubscribeMessage = (GateioWebSocketSubscriptionMessage)this.objectMapper.readValue(this.channelSubscriptionMessages.get(channelName), GateioWebSocketSubscriptionMessage.class);
        unsubscribeMessage.setEvent(UNSUBSCRIBE);
        return this.objectMapper.writeValueAsString((Object)unsubscribeMessage);
    }
}

