/*
 * Decompiled with CFR 0.152.
 */
package dto.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import dto.response.GateioWebSocketTransaction;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.instrument.Instrument;

public class GateioOrderBookResponse
extends GateioWebSocketTransaction {
    @JsonProperty(value="result")
    private Result result;

    @Override
    public CurrencyPair getCurrencyPair() {
        if (this.result.getCurrencyPair() == null) {
            return null;
        }
        return new CurrencyPair(this.result.getCurrencyPair().replace('_', '/'));
    }

    public OrderBook toOrderBook(CurrencyPair currencyPair) {
        List bids = Arrays.stream(this.result.bids).map(rawBid -> new LimitOrder(Order.OrderType.BID, new BigDecimal(rawBid[1]), (Instrument)currencyPair, Long.toString(this.result.lastUpdateId), null, new BigDecimal(rawBid[0]))).collect(Collectors.toList());
        List asks = Arrays.stream(this.result.asks).map(rawAsk -> new LimitOrder(Order.OrderType.ASK, new BigDecimal(rawAsk[1]), (Instrument)currencyPair, Long.toString(this.result.lastUpdateId), null, new BigDecimal(rawAsk[0]))).collect(Collectors.toList());
        return new OrderBook(Date.from(Instant.ofEpochMilli(this.result.updateTimeMilliseconds)), asks, bids, false);
    }

    public Result getResult() {
        return this.result;
    }

    @JsonProperty(value="result")
    public void setResult(Result result) {
        this.result = result;
    }

    public class Result {
        @JsonProperty(value="t")
        private long updateTimeMilliseconds;
        @JsonProperty(value="lastUpdateId")
        private long lastUpdateId;
        @JsonProperty(value="s")
        private String currencyPair;
        @JsonProperty(value="bids")
        private String[][] bids;
        @JsonProperty(value="asks")
        private String[][] asks;

        public long getUpdateTimeMilliseconds() {
            return this.updateTimeMilliseconds;
        }

        public long getLastUpdateId() {
            return this.lastUpdateId;
        }

        public String getCurrencyPair() {
            return this.currencyPair;
        }

        public String[][] getBids() {
            return this.bids;
        }

        public String[][] getAsks() {
            return this.asks;
        }

        @JsonProperty(value="t")
        public void setUpdateTimeMilliseconds(long updateTimeMilliseconds) {
            this.updateTimeMilliseconds = updateTimeMilliseconds;
        }

        @JsonProperty(value="lastUpdateId")
        public void setLastUpdateId(long lastUpdateId) {
            this.lastUpdateId = lastUpdateId;
        }

        @JsonProperty(value="s")
        public void setCurrencyPair(String currencyPair) {
            this.currencyPair = currencyPair;
        }

        @JsonProperty(value="bids")
        public void setBids(String[][] bids) {
            this.bids = bids;
        }

        @JsonProperty(value="asks")
        public void setAsks(String[][] asks) {
            this.asks = asks;
        }
    }
}

