/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.truefx.service;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.client.ClientConfigCustomizer;
import org.knowm.xchange.client.ExchangeRestProxyBuilder;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.service.BaseExchangeService;
import org.knowm.xchange.truefx.TrueFxPublic;
import org.knowm.xchange.truefx.dto.marketdata.TrueFxTicker;
import si.mazi.rescu.serialization.jackson.DefaultJacksonObjectMapperFactory;
import si.mazi.rescu.serialization.jackson.JacksonObjectMapperFactory;

public class TrueFxMarketDataServiceRaw
extends BaseExchangeService {
    private final TrueFxPublic trueFx;
    private final JacksonObjectMapperFactory factory = new DefaultJacksonObjectMapperFactory(){

        protected ObjectMapper createInstance() {
            return new CsvMapper();
        }

        public void configureObjectMapper(ObjectMapper mapper) {
            super.configureObjectMapper(mapper);
            SimpleModule customDeserializer = new SimpleModule(TrueFxTicker.class.getSimpleName(), Version.unknownVersion());
            customDeserializer.addDeserializer(TrueFxTicker.class, (JsonDeserializer)new TrueFxTicker.TrueFxTickerDeserializer());
            mapper.registerModule((Module)customDeserializer);
        }
    };

    protected TrueFxMarketDataServiceRaw(Exchange exchange) {
        super(exchange);
        ClientConfigCustomizer clientConfigCustomizer = config -> config.setJacksonObjectMapperFactory(this.factory);
        this.trueFx = (TrueFxPublic)ExchangeRestProxyBuilder.forInterface(TrueFxPublic.class, (ExchangeSpecification)exchange.getExchangeSpecification()).clientConfigCustomizer(clientConfigCustomizer).build();
    }

    public TrueFxTicker getTicker(CurrencyPair pair) throws IOException {
        return this.trueFx.getTicker(pair);
    }

    public ObjectMapper createObjectMapper() {
        ObjectMapper mapper = this.factory.createObjectMapper();
        this.factory.configureObjectMapper(mapper);
        return mapper;
    }
}

