/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.live.bean.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.polyv.live.util.EncryptionUtils;
import net.polyv.live.util.MapUtil;
import org.apache.commons.lang3.StringUtils;

public abstract class PLBaseRequest {
    protected String appId;
    protected String appSecret;
    protected Long timestamp;
    protected String sign;

    public PLBaseRequest() {
    }

    public PLBaseRequest(String appId, String appSecret) {
        this.appId = appId;
        this.appSecret = appSecret;
        this.timestamp = System.currentTimeMillis();
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public Map<String, String> getParams() {
        Map<String, String> pMap = MapUtil.objectToMap(this);
        Map<String, String> params = this.paraFilter(pMap);
        this.sign = this.generateSign(params);
        params.put("sign", this.sign);
        return params;
    }

    private String generateSign(Map<String, String> params) {
        String concatStr = this.concatParams(params);
        String secret = this.getAppSecret();
        String plain = secret + concatStr + secret;
        return EncryptionUtils.md5Hex(plain).toUpperCase();
    }

    private Map<String, String> paraFilter(Map<String, String> sArray) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (null == sArray || sArray.size() <= 0) {
            return result;
        }
        for (Map.Entry<String, String> entry : sArray.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.isBlank(value) || key.equalsIgnoreCase("appSecret") || key.equalsIgnoreCase("sign") || key.equalsIgnoreCase("requestBody")) continue;
            result.put(key, value);
        }
        return result;
    }

    private String concatParams(Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            sb.append(key).append(value);
        }
        return sb.toString();
    }

    public String toString() {
        return "PLBaseRequest{appId='" + this.appId + '\'' + ", appSecret='" + this.appSecret + '\'' + ", timestamp=" + this.timestamp + ", sign='" + this.sign + '\'' + '}';
    }
}

