package net.polyv.live.v1.entity.account;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LivePageCommonRequest;

/**
 * 分页查询频道接收转播列表请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("分页查询频道接收转播列表请求实体")
public class LiveChannelReceiveListRequest extends LivePageCommonRequest {
    
    /**
     * （发起转播的）频道号
     */
    @ApiModelProperty(name = "channelId", value = "（发起转播的）频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 频道名称，支持模糊搜索
     */
    @ApiModelProperty(name = "keyword", value = "频道名称，支持模糊搜索", required = false)
    private String keyword;
    
}