package net.polyv.live.v1.entity.account;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.live.v1.entity.LivePageCommonResponse;

/**
 * 分页查询频道接收转播列表响应实体
 * @author jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("分页查询频道接收转播列表响应实体")
public class LiveChannelReceiveListResponse extends LivePageCommonResponse {
    
    /**
     * 查询的结果列表【详见Contents参数描述】
     */
    @ApiModelProperty(name = "contents", value = "查询的结果列表【详见Contents参数描述】", required = false)
    private List<LiveChannelReceiveListResponse.ReceiveList> contents;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("查询的结果列表【详见Contents参数描述】")
    public static class ReceiveList {
        
        /**
         * 频道号
         */
        @ApiModelProperty(name = "channelId", value = "频道号", required = false)
        private String channelId;
        
        /**
         * 频道名称
         */
        @ApiModelProperty(name = "name", value = "频道名称", required = false)
        private String name;
        
        /**
         * 频道密码，非研讨会场景使用
         */
        @ApiModelProperty(name = "channelPasswd", value = "频道密码，非研讨会场景使用", required = false)
        private String channelPasswd;
        
        /**
         * 研讨会主持人密码，研讨会场景使用
         */
        @ApiModelProperty(name = "hostPasswd", value = "研讨会主持人密码，研讨会场景使用", required = false)
        private String hostPasswd;
        
        /**
         * 研讨会参会人密码，研讨会场景使用
         */
        @ApiModelProperty(name = "attendeePasswd", value = "研讨会参会人密码，研讨会场景使用", required = false)
        private String attendeePasswd;
        
        /**
         * 频道所属分类名称
         */
        @ApiModelProperty(name = "categoryName", value = "频道所属分类名称", required = false)
        private String categoryName;
        
        /**
         * 观看条件，使用,分隔，如：none,none none：无条件， pay：付费观看， code：验证码观看， phone：白名单观看， info：登记观看， custom：自定义授权观看，
         * external：外部授权, direct：直接授权
         */
        @ApiModelProperty(name = "authType", value = "观看条件，使用,分隔，如：none,none none：无条件， pay：付费观看， code：验证码观看， " +
                "phone：白名单观看， info：登记观看， custom：自定义授权观看， external：外部授权, direct：直接授权", required = false)
        private String authType;
        
        /**
         * 最近场次观看人数
         */
        @ApiModelProperty(name = "recentViewCount", value = "最近场次观看人数", required = false)
        private Integer recentViewCount;
        
        /**
         * 第一个子频道号，如果没有子频道则为null
         */
        @ApiModelProperty(name = "subChannelAccount", value = "第一个子频道号，如果没有子频道则为null", required = false)
        private String subChannelAccount;
        
        /**
         * 第一个子频道密码，如果没有子频道则为null
         */
        @ApiModelProperty(name = "subChannelPasswd", value = "第一个子频道密码，如果没有子频道则为null", required = false)
        private String subChannelPasswd;
        
        /**
         * 关联转播的频道号，如果没有关联则为null
         */
        @ApiModelProperty(name = "transmitChannelId", value = "关联转播的频道号，如果没有关联则为null", required = false)
        private String transmitChannelId;
        
        /**
         * 场景 alone：活动直播 ppt：三分屏 topclass：大班课
         */
        @ApiModelProperty(name = "scene", value = "场景 alone：活动直播 ppt：三分屏 topclass：大班课", required = false)
        private String scene;
    }
}