package net.polyv.live.v1.entity.channel.operate;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 复制频道请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("复制频道请求实体")
public class LiveChannelCopyRequest extends LiveCommonRequest {
    
    /**
     * 需要复制频道的频道号
     */
    @ApiModelProperty(name = "channelId", value = "需要复制频道的频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 新的频道名称，默认为复制频道的频道名称
     */
    @ApiModelProperty(name = "name", value = "新的频道名称，默认为复制频道的频道名称", required = false)
    private String name;
    
    /**
     * 新的频道所属分类ID，默认为默认分类
     */
    @ApiModelProperty(name = "categoryId", value = "新的频道所属分类ID，默认为默认分类", required = false)
    private Integer categoryId;
    
    /**
     * 频道开始时间，格式：yyyy-MM-DD HH:mm:ss，默认为复制频道的开始时间
     */
    @ApiModelProperty(name = "startTime", value = "频道开始时间，格式：yyyy-MM-DD HH:mm:ss，默认为复制频道的开始时间", required = false)
    private String startTime;
    
}