package net.polyv.live.v1.entity.channel.product;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 修改频道商品库开关状态请求实体
 * @author: jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("修改频道商品库开关状态请求实体")
public class LiveUpdateProductEnabledRequest extends LiveCommonRequest {
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 开关状态，Y：开启，N：关闭
     */
    @ApiModelProperty(name = "enabled", value = "开关状态，Y：开启，N：关闭", required = true)
    @NotNull(message = "属性enabled不能为空")
    private String enabled;
}
