package net.polyv.live.v1.entity.channel.viewdata;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 查询频道多场次概览统计数据请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询频道多场次概览统计数据请求实体")
public class LiveGetSessionStatsRequest extends LiveCommonRequest {
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 场次ID，多个场次使用逗号分隔，如：fw82mayhuy,fvipafupmh，场次ID和直播开始结束时间必填一项，场次ID和直播开始结束时间同时存在时，使用场次ID进行查询
     */
    @ApiModelProperty(name = "sessionIds", value = "场次ID，多个场次使用逗号分隔，如：fw82mayhuy," +
            "fvipafupmh，场次ID和直播开始结束时间必填一项，场次ID和直播开始结束时间同时存在时，使用场次ID进行查询", required = false)
    private String sessionIds;
    
    /**
     * 直播开始时间，开始时间和结束时间相隔不可以超过30天
     */
    @ApiModelProperty(name = "startTime", value = "直播开始时间，开始时间和结束时间相隔不可以超过30天", required = false)
    private Date startTime;
    
    /**
     * 直播结束时间，场次ID和直播开始结束时间必填一项
     */
    @ApiModelProperty(name = "endTime", value = "直播结束时间，场次ID和直播开始结束时间必填一项", required = false)
    private Date endTime;
    
}