package net.polyv.live.v1.entity.chat;

import java.util.Date;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LivePageCommonRequest;

/**
 * 查询频道聊天记录请求实体
 * @author jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询频道聊天记录请求实体")
public class LiveGetMessageListRequest extends LivePageCommonRequest {
    /**
     * 聊天记录的开始时间 格式为yyyy-MM-dd，例如：2021-03-01 或者格式为yyyy-MM-dd HH:mm:ss，例如：2021-03-01 16:30:12
     */
    @ApiModelProperty(name = "startDay", value = "聊天记录的开始时间 格式为yyyy-MM-dd，例如：2021-03-01 或者格式为yyyy-MM-dd " +
            "HH:mm:ss，例如：2021-03-01 16:30:12", required = true)
    @NotNull(message = "属性startDay不能为空")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date startDay;
    
    /**
     * 聊天记录的结束时间，要求同上
     */
    @ApiModelProperty(name = "endDay", value = "聊天记录的结束时间，要求同上", required = true)
    @NotNull(message = "属性endDay不能为空")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date endDay;
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 用户类型，可以选择多个类型，用英文逗号隔开 slice：云课堂学员 teacher：讲师 guest：嘉宾 manager：管理员 assistant：助教 viewer：特邀观众 monitor：场监
     * attendee：研讨会参与者 student：普通直播观众
     */
    @ApiModelProperty(name = "userType", value = "用户类型，可以选择多个类型，用英文逗号隔开 slice：云课堂学员 teacher：讲师 guest：嘉宾 manager：管理员 " +
            "assistant：助教 viewer：特邀观众 monitor：场监 attendee：研讨会参与者 student：普通直播观众", required = false)
    private String userType;
    
    /**
     * 聊天记录审核状态，默认pass：已审核 pass：已审核 censor：审核中和删除
     */
    @ApiModelProperty(name = "status", value = "聊天记录审核状态，默认pass：已审核 pass：已审核 censor：审核中和删除", required = false)
    private String status;
    
    /**
     * 类型，不填默认公聊 extend：管理员私聊
     */
    @ApiModelProperty(name = "source", value = "类型，不填默认公聊 extend：管理员私聊", required = false)
    private String source;
    
    /**
     * 如果有房间号，需要传入房间号，默认不传
     */
    @ApiModelProperty(name = "roomId", value = "如果有房间号，需要传入房间号，默认不传", required = false)
    private String roomId;
    
    /**
     * 是否返回当前查询总数，Y：是，N：否，默认为N 注：此参数可能会影响接口响应性能，若非强烈需求，建议不要传此参数，可以根据返回结果中的 contents 数组长度来判断是否还有下一页
     */
    @ApiModelProperty(name = "hasTotal", value =
            "是否返回当前查询总数，Y：是，N：否，默认为N 注：仅在查第一页有效，此参数可能会影响接口响应性能，若非强烈需求，建议不要传此参数，可以根据返回结果中的" +
                    " contents 数组长度来判断是否还有下一页", required = false)
    private String hasTotal;
    
}