package net.polyv.live.v1.entity.player;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 查询频道防录屏信息响应实体
 * @author jiangyifan
 */
@Data
@Accessors(chain = true)
@ApiModel("查询频道防录屏信息响应实体")
public class LiveGetAntiRecordResponse {
    /**
     * 防录屏方式 marquee：跑马灯 watermark：水印
     */
    @ApiModelProperty(name = "antiRecordType", value = "防录屏方式 marquee：跑马灯 watermark：水印", required = false)
    private String antiRecordType;
    
    /**
     * 防录屏类型 fixed：固定值 nickname：登录用户名 diyurl：URL自定义设置
     */
    @ApiModelProperty(name = "modelType", value = "防录屏类型 fixed：固定值 nickname：登录用户名 diyurl：URL自定义设置", required = false)
    private String modelType;
    
    /**
     * 固定值时为设置内容 URL自定义设置时为网址
     */
    @ApiModelProperty(name = "content", value = "固定值时为设置内容 URL自定义设置时为网址", required = false)
    private String content;
    
    /**
     * 透明度，取值0-100，0为不透明
     */
    @ApiModelProperty(name = "opacity", value = "透明度，取值0-100，0为不透明", required = false)
    private Integer opacity;
    
    /**
     * 字体大小 防录屏方式为跑马灯时，设置数值，范围1-256 防录屏方式为水印时 small：小 middle：中 large：大
     */
    @ApiModelProperty(name = "fontSize", value = "字体大小 防录屏方式为跑马灯时，设置数值，范围1-256 防录屏方式为水印时 small：小 middle：中 large：大",
            required = false)
    private String fontSize;
    
    /**
     * 跑马灯字体颜色，色值，水印时不返回此参数
     */
    @ApiModelProperty(name = "fontColor", value = "跑马灯字体颜色，色值，水印时不返回此参数", required = false)
    private String fontColor;
    
    /**
     * 跑马灯自定义缩放，水印时不返回此参数 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "autoZoomEnabled", value = "跑马灯自定义缩放，水印时不返回此参数 Y：开启 N：关闭", required = false)
    private String autoZoomEnabled;
    
    /**
     * 双跑马灯，水印时不返回此参数 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "doubleEnabled", value = "双跑马灯，水印时不返回此参数 Y：开启 N：关闭", required = false)
    private String doubleEnabled;
    
    /**
     * 跑马灯显示方式，水印时不返回此参数 roll：滚动 flicker：闪烁
     */
    @ApiModelProperty(name = "showMode", value = "跑马灯显示方式，水印时不返回此参数 roll：滚动 flicker：闪烁", required = false)
    private String showMode;
    
}