package net.polyv.live.v1.service.channel.impl;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.polyv.live.v1.constant.LiveURL;
import net.polyv.live.v1.entity.channel.doc.LiveChannelDocStatusRequest;
import net.polyv.live.v1.entity.channel.doc.LiveChannelDocStatusResponse;
import net.polyv.live.v1.entity.channel.doc.LiveCreateChannelDocRequest;
import net.polyv.live.v1.entity.channel.doc.LiveCreateChannelDocResponse;
import net.polyv.live.v1.entity.channel.doc.LiveDeleteChannelDocRequest;
import net.polyv.live.v1.entity.channel.doc.LiveListChannelDocRequest;
import net.polyv.live.v1.entity.channel.doc.LiveListChannelDocResponse;
import net.polyv.live.v1.service.LiveBaseService;
import net.polyv.live.v1.service.channel.ILiveChannelDocService;

/**
 * 直播文档管理实现类
 * @author: sadboy
 **/
public class LiveChannelDocServiceImpl extends LiveBaseService implements ILiveChannelDocService {
    
    /**
     * 获取频道文档列表
     * API地址：https://dev.polyv.net/2019/liveproduct/l-api/zbglgn/wdgl/get-ppt-list/
     * @param liveListChannelDocRequest 获取频道文档列表请求实体
     * @return 获取频道文档列表返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveListChannelDocResponse listChannelDoc(LiveListChannelDocRequest liveListChannelDocRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.CHANNEL_DOC_LIST_URL;
        return this.getReturnOne(url, liveListChannelDocRequest, LiveListChannelDocResponse.class);
        
    }
    
    /**
     * 查询频道文档转换状态
     * API地址：https://dev.polyv.net/2019/liveproduct/l-api/zbglgn/wdgl/get-ppt-convert-status/
     * @param liveChannelDocStatusRequest 查询频道文档转换状态请求实体
     * @return 查询频道文档转换状态返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveChannelDocStatusResponse getChannelDocStatus(LiveChannelDocStatusRequest liveChannelDocStatusRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.CHANNEL_DOC_STATUS_URL;
        List<LiveChannelDocStatusResponse.ChannelDocStatus> channelDocStatuses = this.getReturnList(url,
                liveChannelDocStatusRequest, LiveChannelDocStatusResponse.ChannelDocStatus.class);
        LiveChannelDocStatusResponse liveChannelDocStatusResponse = new LiveChannelDocStatusResponse();
        liveChannelDocStatusResponse.setChannelDocStatuses(channelDocStatuses);
        return liveChannelDocStatusResponse;
    }
    
    /**
     * 删除频道文档
     * API地址：https://dev.polyv.net/2019/liveproduct/l-api/zbglgn/wdgl/delete-document/
     * @param liveDeleteChannelDocRequest 删除频道文档请求实体
     * @return 删除频道文档返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean deleteChannelDoc(LiveDeleteChannelDocRequest liveDeleteChannelDocRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.CHANNEL_DOC_DELETE_URL;
        this.postFormBodyReturnOne(url, liveDeleteChannelDocRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 上传频道文档
     * API地址：https://dev.polyv.net/2019/liveproduct/l-api/zbglgn/wdgl/upload-ppt-file/
     * @param liveCreateChannelDocRequest 上传频道文档请求实体
     * @return 上传频道文档返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveCreateChannelDocResponse createChannelDoc(LiveCreateChannelDocRequest liveCreateChannelDocRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.CREATE_CHANNEL_DOC_URL;
        Map<String, File> fileMap = new HashMap<String, File>();
        File file = liveCreateChannelDocRequest.getFile();
        if (file != null) {
            fileMap.put("file", file);
        }
        return this.uploadOneFile(url, liveCreateChannelDocRequest, fileMap, LiveCreateChannelDocResponse.class);
        
    }
    
}
