package net.polyv.live.v1.service.channel.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;

import net.polyv.live.v1.constant.LiveURL;
import net.polyv.live.v2.entity.channel.template.LiveGetUserDonateRequest;
import net.polyv.live.v2.entity.channel.template.LiveGetUserDonateResponse;
import net.polyv.live.v2.entity.channel.template.LiveUpdateUserDonateRequest;
import net.polyv.live.v1.service.LiveBaseService;
import net.polyv.live.v1.service.channel.ILiveChannelTemplateService;

/**
 * 默认模板
 * @author: jiangyifan
 */
public class LiveChannelTemplateServiceImpl extends LiveBaseService implements ILiveChannelTemplateService {
    /**
     * 查询直播模板打赏设置
     * API地址：https://help.polyv.net/#/live/api/v4/user/template/getDonate
     * @param liveGetUserDonateRequest 查询直播模板打赏设置请求实体
     * @return 查询直播模板打赏设置(新版)响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveGetUserDonateResponse getUserDonate(LiveGetUserDonateRequest liveGetUserDonateRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_GET_USER_DONATE_URL;
        return this.getReturnOne(url, liveGetUserDonateRequest, LiveGetUserDonateResponse.class);
    }
    
    /**
     * 修改默认模板礼物打赏设置(新版)
     * API地址：https://help.polyv.net/#/live/api/v4/user/template/updateDonate
     * @param liveUpdateUserDonateRequest 修改默认模板礼物打赏设置(新版)请求实体
     * @return 修改默认模板礼物打赏设置(新版)响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean updateUserDonate(LiveUpdateUserDonateRequest liveUpdateUserDonateRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_UPDATE_USER_DONATE_URL;
        this.postJsonBodyReturnOne(url, liveUpdateUserDonateRequest, String.class);
        return Boolean.TRUE;
    }
}
