package net.polyv.live.v1.service.interact;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;

import net.polyv.live.v2.entity.channel.statistics.LiveGetBookingStatsRequest;
import net.polyv.live.v2.entity.channel.statistics.LiveGetBookingStatsResponse;

/**
 * 微信预约
 * @author: jiangyifan
 */
public interface ILiveWeixinBookingService {
    
    /**
     * 查询微信预约数据
     * API地址：https://help.polyv.net/#/live/api/v4/channel/statistics/weixin_booking_stats
     * @param liveGetBookingStatsRequest 查询微信预约数据请求实体
     * @return 查询微信预约数据响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    LiveGetBookingStatsResponse getBookingStats(LiveGetBookingStatsRequest liveGetBookingStatsRequest)
            throws IOException, NoSuchAlgorithmException;
}
