package net.polyv.live.v2.entity.channel.account;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.live.v1.entity.LivePageNumberCommonRequest;

/**
 * 查询所有频道的基础信息请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询所有频道的基础信息请求实体")
public class LiveListAccountBasicInfoV2Request extends LivePageNumberCommonRequest {
    
    /**
     * 分类ID，多个id用英文逗号分隔
     */
    @ApiModelProperty(name = "categoryIds", value = "分类ID，多个id用英文逗号分隔", required = false)
    private String categoryIds;
    
    /**
     * 频道号，多个频道用英文逗号分隔
     */
    @ApiModelProperty(name = "channelIds", value = "频道号，多个频道用英文逗号分隔", required = false)
    private String channelIds;
    
    /**
     * 观看页状态筛选
     * live：直播中
     * playback：回放中
     * end：已结束
     * waiting：等待中
     * unStart：未开始
     */
    @ApiModelProperty(name = "watchStatus", value = "观看页状态筛选", required = false)
    private String watchStatus;
    
    /**
     * 直播开始时间，查询开始时间13位时间戳
     */
    @ApiModelProperty(name = "startTime", value = "直播开始时间，查询开始时间13位时间戳", required = false)
    private Date startTime;
    
    /**
     * 直播开始时间，查询结束时间13位时间戳
     */
    @ApiModelProperty(name = "endTime", value = "直播开始时间，查询结束时间13位时间戳", required = false)
    private Date endTime;
    
    /**
     * 排序字段，默认按频道创建时间升序
     * startTimeDesc：开播时间降序
     * startTimeAsc：开播时间升序
     * channelCreatedTimeDesc：频道创建时间降序
     */
    @ApiModelProperty(name = "orderBy", value = "排序字段，默认按频道创建时间升序，startTimeDesc：开播时间降序，startTimeAsc" +
            "：开播时间升序，channelCreatedTimeDesc：频道创建时间降序", required = false)
    private String orderBy;
    
}
