package net.polyv.live.v2.entity.channel.distribute;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 查询云分发数据信息请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询云分发数据信息请求实体")
public class LiveChannelDistributeStatisticRequest extends LiveCommonRequest {
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 频道场次ID，多个使用,分隔，场次ID和直播开始结束时间不能同时为空
     */
    @ApiModelProperty(name = "sessionIds", value = "频道场次ID，多个使用,分隔，场次ID和直播开始结束时间不能同时为空", required = false)
    private String sessionIds;
    
    /**
     * 直播开始时间，场次ID和直播开始结束时间不能同时为空
     */
    @ApiModelProperty(name = "startTime", value = "直播开始时间，场次ID和直播开始结束时间不能同时为空", required = false)
    private Date startTime;
    
    /**
     * 直播结束时间，场次ID和直播开始结束时间不能同时为空
     */
    @ApiModelProperty(name = "endTime", value = "直播结束时间，场次ID和直播开始结束时间不能同时为空", required = false)
    private Date endTime;
    
}