package net.polyv.live.v2.entity.channel.distribute;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 修改云分发频道总开关请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("修改云分发频道总开关请求实体")
public class LiveDistributeUpdateMasterSwitchRequest extends LiveCommonRequest {
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 频道云分发总开关，Y：开启，N：关闭，默认为Y
     */
    @ApiModelProperty(name = "distributeEnabled", value = "频道云分发总开关，Y：开启，N：关闭，默认为Y", required = false)
    private String distributeEnabled;
    
    /**
     * 是否强制关闭，Y：强制关闭，N：非强制关闭，默认为N。非强制关闭时，频道如果正常直播中，接口会抛出异常
     */
    @ApiModelProperty(name = "enforce", value = "是否强制关闭，Y：强制关闭，N：非强制关闭，默认为N。非强制关闭时，频道如果正常直播中，接口会抛出异常", required = false)
    private String enforce;
    
}