package net.polyv.live.v2.entity.channel.distribute;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 批量修改频道云分发开关请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("批量修改频道云分发开关请求实体")
public class LiveDistributeUpdateSwitchRequest extends LiveCommonRequest {
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 云分发列表id，多个使用,分隔
     */
    @ApiModelProperty(name = "distributeIds", value = "云分发列表id，多个使用,分隔", required = true)
    @NotNull(message = "属性distributeIds不能为空")
    private String distributeIds;
    
    /**
     * 云分发开关，Y：开启，N：关闭，默认为N
     */
    @ApiModelProperty(name = "distributeEnabled", value = "云分发开关，Y：开启，N：关闭，默认为N", required = false)
    private String distributeEnabled;
    
}