package net.polyv.live.v2.entity.channel.operate;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 创建并初始化频道响应实体
 * @author jiangyifan
 */
@Data
@Accessors(chain = true)
@ApiModel("创建并初始化频道响应实体")
public class LiveChannelInitV2Response {
    
    /**
     * 频道ID
     */
    @ApiModelProperty(name = "channelId", value = "频道ID", required = false)
    private String channelId;
    
    /**
     * 频道名称
     */
    @ApiModelProperty(name = "name", value = "频道名称", required = false)
    private String name;
    
    /**
     * POLYV用户ID，和保利威官网一致，获取路径：官网->登录->直播（开发设置）
     */
    @ApiModelProperty(name = "userId", value = "POLYV用户ID，和保利威官网一致，获取路径：官网->登录->直播（开发设置）", required = false)
    private String userId;
    
    /**
     * 讲师登录密码，非研讨会场景使用，长度6-16位
     */
    @ApiModelProperty(name = "channelPasswd", value = "讲师登录密码，非研讨会场景使用，长度6-16位", required = false)
    private String channelPasswd;
    
    /**
     * 研讨会主持人密码，仅直播场景是研讨会时返回，长度6-16位
     */
    @ApiModelProperty(name = "seminarHostPassword", value = "研讨会主持人密码，仅直播场景是研讨会时返回，长度6-16位", required = false)
    private String seminarHostPassword;
    
    /**
     * 研讨会参会人密码，仅直播场景是研讨会时返回，长度6-16位
     */
    @ApiModelProperty(name = "seminarAttendeePassword", value = "研讨会参会人密码，仅直播场景是研讨会时返回，长度6-16位", required = false)
    private String seminarAttendeePassword;
    
    /**
     * 主持人名称
     */
    @ApiModelProperty(name = "publisher", value = "主持人名称", required = false)
    private String publisher;
    
    /**
     * 直播介绍
     */
    @ApiModelProperty(name = "description", value = "直播介绍", required = false)
    private String description;
    
    /**
     * 直播场景 (topclass-大班课 、 double-双师课（该场景需开通） 、 train-企业培训 、 seminar-研讨会 、 alone-活动营销)
     */
    @ApiModelProperty(name = "newScene", value = "直播场景 (topclass-大班课 、 double-双师课（该场景需开通） 、 train-企业培训 、 seminar-研讨会 " +
            "、 alone-活动营销)", required = false)
    private String newScene;
    
    /**
     * 直播模板 (ppt-三分屏(横屏) 、 portrait_ppt-三分屏(竖屏) 、 alone-纯视频(横屏) 、portrait_alone-纯视频(竖屏) 、 topclass-纯视频-极速(横屏) 、
     * portrait_topclass-纯视频-极速(竖屏) 、 seminar-研讨会)
     * 直播场景为topclass时，该字段支持ppt、portrait_ppt、alone、portrait_alone、topclass、portrait_topclass
     * 直播场景为train或alone时，该字段支持ppt、portrait_ppt、alone、portrait_alone 直播场景为double时，该字段支持ppt、alone
     * 直播场景为seminar时，该字段支持seminar
     */
    @ApiModelProperty(name = "template", value = "直播模板 (ppt-三分屏(横屏) 、 portrait_ppt-三分屏(竖屏) 、 alone-纯视频(横屏) " +
            "、portrait_alone-纯视频(竖屏) 、 topclass-纯视频-极速(横屏) 、 portrait_topclass-纯视频-极速(竖屏) 、 seminar-研讨会) " +
            "直播场景为topclass时，该字段支持ppt、portrait_ppt、alone、portrait_alone、topclass、portrait_topclass " +
            "直播场景为train或alone时，该字段支持ppt、portrait_ppt、alone、portrait_alone 直播场景为double时，该字段支持ppt、alone " +
            "直播场景为seminar时，该字段支持seminar", required = false)
    private String template;
    
    /**
     * 连麦人数
     */
    @ApiModelProperty(name = "linkMicLimit", value = "连麦人数", required = false)
    private Integer linkMicLimit;
    
    /**
     * 直播延迟 Y：无延时迟 N：普通延迟
     */
    @ApiModelProperty(name = "pureRtcEnabled", value = "直播延迟 Y：无延时迟 N：普通延迟", required = false)
    private String pureRtcEnabled;
    
    /**
     * 频道类型 发起转播：transmit 接收转播：receive 普通频道：normal
     */
    @ApiModelProperty(name = "type", value = "频道类型 发起转播：transmit 接收转播：receive 普通频道：normal", required = false)
    private String type;
    
    /**
     * 当前13位毫秒级时间戳
     */
    @ApiModelProperty(name = "currentTimeMillis", value = "当前13位毫秒级时间戳", required = false)
    private Date currentTimeMillis;
    
}