package net.polyv.live.v2.entity.channel.operate;

import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotEmpty;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 批量创建频道请求实体
 * @author jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("批量创建频道请求实体")
public class LiveCreateChannelListV2Request extends LiveCommonRequest {
    
    /**
     * 批量创建频道请求体
     */
    @ApiModelProperty(name = "channels", value = "批量创建频道请求体", required = true)
    @NotEmpty(message = "属性channels不能为空")
    private List<LiveCreateChannelListV2Request.ChannelV2CreateBatch> channels;
    
    @Data
    @Builder
    @Accessors(chain = true)
    @ApiModel("批量创建频道实体")
    public static class ChannelV2CreateBatch {
        /**
         * 直播名称，最大长度100
         */
        @ApiModelProperty(name = "name", value = "直播名称，最大长度100", required = true)
        @NotNull(message = "属性name不能为空")
        private String name;
        
        /**
         * 直播场景 (topclass-大班课 、 double-双师课（该场景需开通） 、 train-企业培训 、 seminar-研讨会 、 alone-活动营销)
         */
        @ApiModelProperty(name = "newScene", value =
                "直播场景 (topclass-大班课 、 double-双师课（该场景需开通） 、 train-企业培训 、 seminar-研讨会 " +
                        "、 alone-活动营销)", required = true)
        @NotNull(message = "属性newScene不能为空")
        private String newScene;
        
        /**
         * 直播模板 (ppt-三分屏(横屏) 、 portrait_ppt-三分屏(竖屏) 、 alone-纯视频(横屏) 、portrait_alone-纯视频(竖屏) 、 topclass-纯视频-极速(横屏) 、
         * portrait_topclass-纯视频-极速(竖屏) 、 seminar-研讨会)
         * <br/>直播场景为topclass时，该字段支持ppt、portrait_ppt、alone、portrait_alone、topclass、portrait_topclass<br/>直播场景为train
         * 或alone时，该字段支持ppt、portrait_ppt、alone、portrait_alone<br/>直播场景为double时，该字段支持ppt、alone<br/>直播场景为seminar
         * 时，该字段支持seminar
         */
        @ApiModelProperty(name = "template", value = "直播模板 (ppt-三分屏(横屏) 、 portrait_ppt-三分屏(竖屏) 、 alone-纯视频(横屏) " +
                "、portrait_alone-纯视频(竖屏) 、 topclass-纯视频-极速(横屏) 、 portrait_topclass-纯视频-极速(竖屏) 、 seminar-研讨会)" +
                "<br/>直播场景为topclass时，该字段支持ppt、portrait_ppt、alone、portrait_alone、topclass、portrait_topclass<br" +
                "/>直播场景为train或alone时，该字段支持ppt、portrait_ppt、alone、portrait_alone<br/>直播场景为double时，该字段支持ppt、alone<br" +
                "/>直播场景为seminar时，该字段支持seminar", required = true)
        @NotNull(message = "属性template不能为空")
        private String template;
        
        /**
         * 讲师登录密码，直播场景不是研讨会时有效，长度6-16位，不传则由系统随机生成
         */
        @ApiModelProperty(name = "channelPasswd", value = "讲师登录密码，直播场景不是研讨会时有效，长度6-16位，不传则由系统随机生成", required = false)
        private String channelPasswd;
        
        /**
         * 研讨会主持人密码，仅直播场景是研讨会时有效，长度6-16位，不传则由系统随机生成。研讨会主持人密码和参会人密码不能相同。
         */
        @ApiModelProperty(name = "seminarHostPassword", value = "研讨会主持人密码，仅直播场景是研讨会时有效，长度6-16" +
                "位，不传则由系统随机生成。研讨会主持人密码和参会人密码不能相同。", required = false)
        private String seminarHostPassword;
        
        /**
         * 研讨会参会人密码，仅直播场景是研讨会时有效，长度6-16位，不传则由系统随机生成。研讨会主持人密码和参会人密码不能相同。
         */
        @ApiModelProperty(name = "seminarAttendeePassword", value = "研讨会参会人密码，仅直播场景是研讨会时有效，长度6-16" +
                "位，不传则由系统随机生成。研讨会主持人密码和参会人密码不能相同。", required = false)
        private String seminarAttendeePassword;
        
        /**
         * 直播延迟 Y无延时 N普通延迟
         */
        @ApiModelProperty(name = "pureRtcEnabled", value = "直播延迟 Y无延时 N普通延迟", required = false)
        private String pureRtcEnabled;
        
        /**
         * 转播类型 normal不开启、transmit发起转播、receive接收转播（该功能需要开通），部分直播场景不支持转播设置，具体请阅读接口约束
         */
        @ApiModelProperty(name = "type", value = "转播类型 normal不开启、transmit发起转播、receive" +
                "接收转播（该功能需要开通），部分直播场景不支持转播设置，具体请阅读接口约束", required = false)
        private String type;
        
        /**
         * 线上双师 transmit大房间、receive小房间
         */
        @ApiModelProperty(name = "doubleTeacherType", value = "线上双师 transmit大房间、receive小房间", required = false)
        private String doubleTeacherType;
        
        /**
         * 中英双语直播开关 Y开、N关
         */
        @ApiModelProperty(name = "cnAndEnLiveEnabled", value = "中英双语直播开关 Y开、N关", required = false)
        private String cnAndEnLiveEnabled;
        
        /**
         * 封面图片地址，非保利威域名下的图片需调用上传频道所有装修图片素材上传
         */
        @ApiModelProperty(name = "splashImg", value = "封面图片地址，非保利威域名下的图片需调用上传频道所有装修图片素材上传", required = false)
        private String splashImg;
        
        /**
         * 连麦人数限制，最多16人
         */
        @ApiModelProperty(name = "linkMicLimit", value = "连麦人数限制，最多16人", required = false)
        private Integer linkMicLimit;
        
        /**
         * 分类ID，可通过“查询直播分类”接口获取
         */
        @ApiModelProperty(name = "categoryId", value = "分类ID，可通过“查询直播分类”接口获取", required = false)
        private Integer categoryId;
        
        /**
         * 开始时间
         */
        @ApiModelProperty(name = "startTime", value = "开始时间", required = false)
        private Date startTime;
        
        /**
         * 子账号邮箱，填写时频道会创建在该子账号下（子账号不能被删除或者禁用），暂无法通过接口获取
         */
        @ApiModelProperty(name = "subAccount", value = "子账号邮箱，填写时频道会创建在该子账号下（子账号不能被删除或者禁用），暂无法通过接口获取", required = false)
        private String subAccount;
    }
}