package net.polyv.live.v2.entity.channel.operate;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 批量创建频道响应实体
 * @author jiangyifan
 */
@Data
@Accessors(chain = true)
@ApiModel("批量创建频道响应实体")
public class LiveCreateChannelListV2Response {
    
    /**
     * 频道ID
     */
    @ApiModelProperty(name = "channelId", value = "频道ID", required = false)
    private String channelId;
    
    /**
     * 校验信息
     */
    @ApiModelProperty(name = "userId", value = "校验信息", required = false)
    private String userId;
    
    /**
     * 直播场景
     */
    @ApiModelProperty(name = "scene", value = "直播场景", required = false)
    private String scene;
    
    /**
     * 讲师登录密码，非研讨会场景使用，长度6-16位
     */
    @ApiModelProperty(name = "channelPasswd", value = "讲师登录密码，非研讨会场景使用，长度6-16位", required = false)
    private String channelPasswd;
    
    /**
     * 研讨会主持人密码，仅直播场景是研讨会时返回，长度6-16位
     */
    @ApiModelProperty(name = "seminarHostPassword", value = "研讨会主持人密码，仅直播场景是研讨会时返回，长度6-16位", required = false)
    private String seminarHostPassword;
    
    /**
     * 研讨会参会人密码，仅直播场景是研讨会时返回，长度6-16位
     */
    @ApiModelProperty(name = "seminarAttendeePassword", value = "研讨会参会人密码，仅直播场景是研讨会时返回，长度6-16位", required = false)
    private String seminarAttendeePassword;
    
}