package net.polyv.live.v2.entity.channel.state;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 批量查询频道直播状态响应实体
 * @author jiangyifan
 */
@Data
@Accessors(chain = true)
@ApiModel("批量查询频道直播状态响应实体")
public class LiveListChannelStreamStatusV2Response {
    
    /**
     * 频道ID
     */
    @ApiModelProperty(name = "channelId", value = "频道ID", required = false)
    private String channelId;
    
    /**
     * 直播状态 unStart：未开始 live：直播中 end：已结束 waiting：等待中 playback：回放中
     */
    @ApiModelProperty(name = "liveStatus", value = "直播状态 unStart：未开始 live：直播中 end：已结束 waiting：等待中 playback：回放中",
            required = false)
    private String liveStatus;
    
}