package net.polyv.live.v2.entity.channel.statistics;

import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.live.v1.entity.LivePageCommonResponse;

/**
 * 查询微信预约数据响应实体
 * @author jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询微信预约数据响应实体")
public class LiveGetBookingStatsResponse extends LivePageCommonResponse {
    
    /**
     * 当前页内容【详见contents字段说明】
     */
    @ApiModelProperty(name = "contents", value = "当前页内容【详见contents字段说明】", required = false)
    private List<LiveGetBookingStatsResponse.BookingStatsList> contents;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("当前页内容【详见contents字段说明】")
    public static class BookingStatsList {
        
        /**
         * 频道号
         */
        @ApiModelProperty(name = "channelId", value = "频道号", required = false)
        private String channelId;
        
        /**
         * 频道名称
         */
        @ApiModelProperty(name = "channelName", value = "频道名称", required = false)
        private String channelName;
        
        /**
         * 用户Id（微信openId）
         */
        @ApiModelProperty(name = "openId", value = "用户Id（微信openId）", required = false)
        private String openId;
        
        /**
         * 预约时间，13位毫秒级时间戳
         */
        @ApiModelProperty(name = "createdTime", value = "预约时间，13位毫秒级时间戳", required = false)
        private Date createdTime;
    }
}