package net.polyv.live.v2.entity.channel.statistics;

import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.live.v1.entity.LivePageCommonResponse;

/**
 * 查询邀请海报明细数据响应实体
 * @author jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询邀请海报明细数据响应实体")
public class LiveGetInviteStatsResponse extends LivePageCommonResponse {
    
    /**
     * 当前页内容
     */
    @ApiModelProperty(name = "contents", value = "当前页内容", required = false)
    private List<LiveGetInviteStatsResponse.InviteStats> contents;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("当前页内容")
    public static class InviteStats {
        
        /**
         * 自定义邀请Id（默认为空，需要配置才有值）
         */
        @ApiModelProperty(name = "invitee", value = "自定义邀请Id（默认为空，需要配置才有值）", required = false)
        private String invitee;
        
        /**
         * 邀请人微信openId
         */
        @ApiModelProperty(name = "openId", value = "邀请人微信openId", required = false)
        private String openId;
        
        /**
         * 邀请人ViewerID
         */
        @ApiModelProperty(name = "viewerId", value = "邀请人ViewerID", required = false)
        private String viewerId;
        
        /**
         * 邀请人昵称
         */
        @ApiModelProperty(name = "nickname", value = "邀请人昵称", required = false)
        private String nickname;
    
        /**
         * 邀请人头像url
         */
        @ApiModelProperty(name = "avatar", value = "邀请人头像url", required = false)
        private String avatar;
        
        /**
         * 海报生成时间，13位毫秒级时间戳
         */
        @ApiModelProperty(name = "createdTime", value = "海报生成时间，13位毫秒级时间戳", required = false)
        private Date createdTime;
        
        /**
         * 受邀人昵称
         */
        @ApiModelProperty(name = "receiverNickname", value = "受邀人昵称", required = false)
        private String receiverNickname;
        
        /**
         * 受邀人微信openId
         */
        @ApiModelProperty(name = "receiverOpenId", value = "受邀人微信openId", required = false)
        private String receiverOpenId;
        
        /**
         * 受邀人ViewerId
         */
        @ApiModelProperty(name = "receiverViewerId", value = "受邀人ViewerId", required = false)
        private String receiverViewerId;
        
        /**
         * 受邀时间，13位毫秒级时间戳
         */
        @ApiModelProperty(name = "receiverTime", value = "受邀时间，13位毫秒级时间戳", required = false)
        private Date receiverTime;
    
        /**
         * 受邀人头像url
         */
        @ApiModelProperty(name = "receiverAvatar", value = "受邀人头像url", required = false)
        private String receiverAvatar;
    }
}