package net.polyv.live.v2.entity.channel.viewdata;

import java.util.Date;
import java.util.List;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.live.v1.entity.LivePageCommonResponse;

/**
 * 查询时间内直播场次数据响应实体
 * @author jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询时间内直播场次数据响应实体")
public class LiveGetLiveSessionResponse extends LivePageCommonResponse {
    
    @ApiModelProperty(name = "contents", value = "直播场次数据", required = false)
    private List<ChannelLiveSession> contents;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("直播场次数据")
    public static class ChannelLiveSession {
        /**
         * 频道ID
         */
        @ApiModelProperty(name = "channelId", value = "频道ID", required = false)
        private String channelId;
        
        /**
         * 直播场次ID
         */
        @ApiModelProperty(name = "sessionId", value = "直播场次ID", required = false)
        private String sessionId;
        
        /**
         * 场次名称
         */
        @ApiModelProperty(name = "name", value = "场次名称", required = false)
        private String name;
        
        /**
         * 直播开始时间，时间格式 yyyy-MM-dd HH:mm:ss
         */
        @ApiModelProperty(name = "startTime", value = "直播开始时间，时间格式 yyyy-MM-dd HH:mm:ss", required = false)
        @JSONField(format = "yyyy-MM-dd HH:mm:ss")
        private Date startTime;
        
        /**
         * 直播结束时间，时间格式 yyyy-MM-dd HH:mm:ss
         */
        @ApiModelProperty(name = "endTime", value = "直播结束时间，时间格式 yyyy-MM-dd HH:mm:ss", required = false)
        @JSONField(format = "yyyy-MM-dd HH:mm:ss")
        private Date endTime;
        
        /**
         * 用户ID
         */
        @ApiModelProperty(name = "userId", value = "用户ID", required = false)
        private String userId;
    }
}