package net.polyv.live.v2.entity.channel.viewdata;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LivePageNumberCommonRequest;

/**
 * 查询频道点赞详情请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询频道点赞详情请求实体")
public class LiveListChannelLikeRequest extends LivePageNumberCommonRequest {
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 场次ID
     */
    @ApiModelProperty(name = "sessionId", value = "场次ID", required = false)
    private String sessionId;
    
    /**
     * 开始时间
     */
    @ApiModelProperty(name = "startTime", value = "开始时间", required = false)
    private Date startTime;
    
    /**
     * 结束时间
     */
    @ApiModelProperty(name = "endTime", value = "结束时间", required = false)
    private Date endTime;
    
}