package net.polyv.live.v2.entity.channel.viewdata;

import java.util.Date;
import java.util.List;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.live.v1.entity.LivePageCommonResponse;

/**
 * 查询频道点赞详情响应实体
 * @author jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询频道点赞详情响应实体")
public class LiveListChannelLikeResponse extends LivePageCommonResponse {
    
    /**
     * 频道点赞内容
     */
    @ApiModelProperty(name = "contents", value = "频道点赞内容", required = false)
    private List<LiveListChannelLikeResponse.ChannelLike> contents;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("频道点赞内容")
    public static class ChannelLike {
        
        /**
         * 观众ID
         */
        @ApiModelProperty(name = "userId", value = "观众ID", required = false)
        private String userId;
        
        /**
         * 昵称
         */
        @ApiModelProperty(name = "nickName", value = "昵称", required = false)
        private String nickName;
        
        /**
         * 点赞时间
         */
        @ApiModelProperty(name = "likeTime", value = "点赞时间", required = false)
        @JSONField(name = "timeStamp")
        private Date likeTime;
        
        /**
         * 点赞次数
         */
        @ApiModelProperty(name = "likeCount", value = "点赞次数", required = false)
        @JSONField(name = "count")
        private Integer likeCount;
        
        /**
         * 场次ID
         */
        @ApiModelProperty(name = "sessionId", value = "场次ID", required = false)
        private String sessionId;
    }
}