package net.polyv.live.v2.entity.channel.web.interact.cardpush;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 查询频道卡片推送响应实体
 * @author jiangyifan
 */
@Data
@Accessors(chain = true)
@ApiModel("查询频道卡片推送响应实体")
public class LiveGetChannelCardPushResponse {
    
    /**
     * 卡片推送主键ID
     */
    @ApiModelProperty(name = "id", value = "卡片推送主键ID", required = false)
    private Long id;
    
    /**
     * 频道ID
     */
    @ApiModelProperty(name = "channelId", value = "频道ID", required = false)
    private String channelId;
    
    /**
     * 卡片标题，最多16个字符
     */
    @ApiModelProperty(name = "title", value = "卡片标题，最多16个字符", required = false)
    private String title;
    
    /**
     * 卡片样式类型，giftbox：礼物领取样式，redpack：红包样式
     */
    @ApiModelProperty(name = "imageType", value = "卡片样式类型，giftbox：礼物领取样式，redpack：红包样式", required = false)
    private String imageType;
    
    /**
     * 卡片倒计时时长，取值：0,5,10,20,30，单位：秒，0为不显示倒计时时长
     */
    @ApiModelProperty(name = "duration", value = "卡片倒计时时长，取值：0,5,10,20,30，单位：秒，0为不显示倒计时时长", required = false)
    private Integer duration;
    
    /**
     * 卡片跳转链接地址，带http://等协议头
     */
    @ApiModelProperty(name = "link", value = "卡片跳转链接地址，带http://等协议头", required = false)
    private String link;
    
    /**
     * 推送结束时间
     */
    @ApiModelProperty(name = "pushEndTime", value = "推送结束时间", required = false)
    private Date pushEndTime;
    
    /**
     * 创建时间
     */
    @ApiModelProperty(name = "createdTime", value = "创建时间", required = false)
    private Date createdTime;
    
    /**
     * 修改时间
     */
    @ApiModelProperty(name = "lastModified", value = "修改时间", required = false)
    private Date lastModified;
    
    /**
     * 推送状态Y.推送中、N.未推送、L.上次推送
     */
    @ApiModelProperty(name = "pushStatus", value = "推送状态Y.推送中、N.未推送、L.上次推送", required = false)
    private String pushStatus;
    
    /**
     * 推送时间
     */
    @ApiModelProperty(name = "pushTime", value = "推送时间", required = false)
    private Date pushTime;
    
    /**
     * 卡片入口Y.开启、N.关闭
     */
    @ApiModelProperty(name = "enterEnabled", value = "卡片入口Y.开启、N.关闭", required = false)
    private String enterEnabled;
    
    /**
     * 弹出方式，PUSH.推送后立即弹出、WATCH.观看后弹出
     */
    @ApiModelProperty(name = "showCondition", value = "弹出方式，PUSH.推送后立即弹出、WATCH.观看后弹出", required = false)
    private String showCondition;
    
    /**
     * 观看时长
     */
    @ApiModelProperty(name = "conditionValue", value = "观看时长", required = false)
    private Integer conditionValue;
    
    /**
     * 观看时长单位SECONDS.秒、MINUTES.分钟
     */
    @ApiModelProperty(name = "conditionUnit", value = "观看时长单位SECONDS.秒、MINUTES.分钟", required = false)
    private String conditionUnit;
    
    /**
     * 倒计时文案，showCondition为WATCH时生效，最多8个字符
     */
    @ApiModelProperty(name = "countdownMsg", value = "倒计时文案，showCondition为WATCH时生效，最多8个字符", required = false)
    private String countdownMsg;
    
}