package net.polyv.live.v2.entity.chat;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 查询频道虚拟人数详情响应实体
 * @author jiangyifan
 */
@Data
@Accessors(chain = true)
@ApiModel("查询频道虚拟人数详情响应实体")
public class LiveGetRobotStatsResponse {
    
    /**
     * 真实人数
     */
    @ApiModelProperty(name = "realViewerCount", value = "真实人数", required = false)
    private Integer realViewerCount;
    
    /**
     * 虚拟人数
     */
    @ApiModelProperty(name = "robotCount", value = "虚拟人数", required = false)
    private Integer robotCount;
    
    /**
     * 显示人数
     */
    @ApiModelProperty(name = "displayCount", value = "显示人数", required = false)
    private Integer displayCount;
    
    /**
     * 真实预约人数
     */
    @ApiModelProperty(name = "realSubscribeCount", value = "真实预约人数", required = false)
    private Integer realSubscribeCount;
    
    /**
     * 观看次数
     */
    @ApiModelProperty(name = "pv", value = "观看次数", required = false)
    private Long pv;
    
}