package net.polyv.live.v2.entity.chat;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.Max;
import net.polyv.common.v1.validator.constraints.Min;
import net.polyv.common.v1.validator.constraints.NotBlank;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 设置频道虚拟人数请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("设置频道虚拟人数请求实体")
public class LiveUpdateRobotSettingRequest extends LiveCommonRequest {
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotBlank(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 聊天室显示虚拟人数
     */
    @ApiModelProperty(name = "robotNumber", value = "聊天室显示虚拟人数", required = true)
    @NotNull(message = "属性robotNumber不能为空")
    private Integer robotNumber;
    
    /**
     * 人数显示模式 timely：立即生效 fixed_time：分时生效
     */
    @ApiModelProperty(name = "addRobotModel", value = "人数显示模式 timely：立即生效 fixed_time：分时生效", required = true)
    @NotNull(message = "属性addRobotModel不能为空")
    private String addRobotModel;
    
    /**
     * 生效时间，addRobotModel为fixed_time分时生效时必填，单位秒，最小值为20（20秒），最大值为18000（300分钟）
     */
    @ApiModelProperty(name = "changeTime", value = "生效时间，addRobotModel为fixed_time分时生效时必填，单位秒，最小值为20（20秒），最大值为18000" +
            "（300分钟）", required = false)
    @Max(value = 18000, message = "changeTime不能超过18000")
    @Min(value = 20, message = "changeTime不能小于20")
    private Integer changeTime;
    
    /**
     * 虚拟预约人数
     */
    @ApiModelProperty(name = "virtualBookingNumber", value = "虚拟预约人数", required = false)
    private Integer virtualBookingNumber;
    
}