package net.polyv.live.v2.entity.user.children;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;
import net.polyv.live.v1.service.children.impl.ILiveChildrenServiceImpl;

/**
 * 新增组织请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("新增组织请求实体")
public class LiveCreateOrganizationRequest extends LiveCommonRequest {
    
    /**
     * 父节点组织ID
     * 可通过查询组织架构列表获取 {@link ILiveChildrenServiceImpl#getOrganizationList}
     */
    @ApiModelProperty(name = "parentId", value = "父节点组织ID", required = true)
    @NotNull(message = "属性parentId不能为空")
    private Integer parentId;
    
    /**
     * 组织架构名称，最大长度12个字符
     */
    @ApiModelProperty(name = "name", value = "组织架构名称，最大长度12个字符", required = true)
    @NotNull(message = "属性name不能为空")
    private String name;
    
    /**
     * 组织描述，最大长度100个字符
     */
    @ApiModelProperty(name = "description", value = "组织描述，最大长度100个字符", required = false)
    private String description;
    
}