package net.polyv.live.v2.entity.user.children;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 删除子账号请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("删除子账号请求实体")
public class LiveDeleteUserChildrenRequest extends LiveCommonRequest {
    
    /**
     * 子账号邮箱
     */
    @ApiModelProperty(name = "childEmail", value = "子账号邮箱", required = true)
    @NotNull(message = "属性childEmail不能为空")
    private String childEmail;
    
}