package net.polyv.live.v2.entity.user.global;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 修改页脚设置请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("修改页脚设置请求实体")
public class LiveUpdateFooterSettingRequest extends LiveCommonRequest {
    
    /**
     * 是否开启页脚 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "showFooterEnabled", value = "是否开启页脚 Y：开启 N：关闭", required = false)
    private String showFooterEnabled;
    
    /**
     * 页脚文案，最大长度12
     */
    @ApiModelProperty(name = "footerText", value = "页脚文案，最大长度12", required = false)
    private String footerText;
    
    /**
     * 页脚链接协议头 http:// 或者 https://
     */
    @ApiModelProperty(name = "footTextLinkProtocol", value = "页脚链接协议头 http:// 或者 https://", required = false)
    private String footTextLinkProtocol;
    
    /**
     * 页脚链接地址，最大长度50，不用带协议，例如：www.polyv.net
     */
    @ApiModelProperty(name = "footTextLinkUrl", value = "页脚链接地址，最大长度50，不用带协议，例如：www.polyv.net", required = false)
    private String footTextLinkUrl;
    
}