package net.polyv.live.v2.entity.user.global;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 修改全局频道设置请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("修改全局频道设置请求实体")
public class LiveUpdateGlobalSwitchRequest extends LiveCommonRequest {
    
    /**
     * 最高同时在线人数修改开关 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "channelConcurrencesEnabled", value = "最高同时在线人数修改开关 Y：开启 N：关闭", required = false)
    private String channelConcurrencesEnabled;
    
    /**
     * 自动转存开关 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "timelyConvertEnabled", value = "自动转存开关 Y：开启 N：关闭", required = false)
    private String timelyConvertEnabled;
    
    /**
     * 打赏开关 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "donateEnabled", value = "打赏开关 Y：开启 N：关闭", required = false)
    private String donateEnabled;
    
    /**
     * 重制课件自动转存开关 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "rebirthAutoUploadEnabled", value = "重制课件自动转存开关 Y：开启 N：关闭", required = false)
    private String rebirthAutoUploadEnabled;
    
    /**
     * 重制课件自动重制开关 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "rebirthAutoConvertEnabled", value = "重制课件自动重制开关 Y：开启 N：关闭", required = false)
    private String rebirthAutoConvertEnabled;
    
    /**
     * 重制课件PPT铺满开关 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "pptCoveredEnabled", value = "重制课件PPT铺满开关 Y：开启 N：关闭", required = false)
    private String pptCoveredEnabled;
    
    /**
     * 播放器封面设置 contain：等比例缩放 cover：拉伸
     */
    @ApiModelProperty(name = "coverImgType", value = "播放器封面设置 contain：等比例缩放 cover：拉伸", required = false)
    private String coverImgType;
    
}