package net.polyv.live.v2.entity.user.global;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 修改观看次数显示开关请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("修改观看次数显示开关请求实体")
public class LiveUpdatePVShowSettingRequest extends LiveCommonRequest {
    
    /**
     * 观看页观看次数显示开关 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "enabled", value = "观看页观看次数显示开关 Y：开启 N：关闭", required = true)
    @NotNull(message = "属性enabled不能为空")
    private String enabled;
    
}