/*
 * Decompiled with CFR 0.152.
 */
package kreuzberg.miniserver.loom;

import java.io.Serializable;
import java.nio.ByteBuffer;
import kreuzberg.miniserver.DeploymentType;
import kreuzberg.miniserver.DeploymentType$;
import kreuzberg.miniserver.Index$;
import kreuzberg.miniserver.Location;
import kreuzberg.miniserver.MiniServerConfig;
import kreuzberg.miniserver.loom.ApiHandler$;
import kreuzberg.rpc.Dispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Using;
import scala.util.Using$;
import sttp.model.StatusCode;
import sttp.model.StatusCode$;
import sttp.tapir.Endpoint;
import sttp.tapir.EndpointErrorOutputsOps;
import sttp.tapir.EndpointInput;
import sttp.tapir.EndpointInputsOps;
import sttp.tapir.EndpointOutput;
import sttp.tapir.EndpointOutputsOps;
import sttp.tapir.package$;
import sttp.tapir.server.ServerEndpoint;
import sttp.tapir.server.netty.NettySocketConfig;
import sttp.tapir.server.netty.NettySocketConfig$;
import sttp.tapir.server.netty.sync.NettySyncServer$;
import sttp.tapir.swagger.bundle.SwaggerInterpreter$;
import sttp.tapir.typelevel.ParamConcat$;
import sttp.tapir.typelevel.TupleArity$;

public class MiniServer {
    private final MiniServerConfig<Object> config;
    private final Logger logger;
    private final String indexHtml;
    private final Endpoint<BoxedUnit, List<String>, StatusCode, ByteBuffer, Object> assetEndpoint;
    private final ServerEndpoint assetHandler;
    private final Endpoint<BoxedUnit, BoxedUnit, BoxedUnit, String, Object> indexEndpoint;
    private final ServerEndpoint indexHandler;
    private final Endpoint<BoxedUnit, List<String>, BoxedUnit, String, Object> otherIndexEndpoint;
    private final ServerEndpoint otherIndexHandler;
    private final Option<ServerEndpoint> apiEndpointHandler;

    public MiniServer(MiniServerConfig<Object> config) {
        this.config = config;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.indexHtml = Index$.MODULE$.apply(config.deployment()).index().toString();
        this.assetEndpoint = (Endpoint)((EndpointOutputsOps)((EndpointErrorOutputsOps)((EndpointInputsOps)package$.MODULE$.endpoint().get()).in(package$.MODULE$.stringToPath("assets").$div((EndpointInput)package$.MODULE$.paths(), ParamConcat$.MODULE$.concatUnitLeft(TupleArity$.MODULE$.tupleArity1())), ParamConcat$.MODULE$.concatUnitLeft(TupleArity$.MODULE$.tupleArity1()))).errorOut((EndpointOutput)package$.MODULE$.statusCode(), ParamConcat$.MODULE$.concatUnitLeft(TupleArity$.MODULE$.tupleArity1()))).out((EndpointOutput)package$.MODULE$.byteBufferBody(), ParamConcat$.MODULE$.concatUnitLeft(TupleArity$.MODULE$.tupleArity1()));
        this.assetHandler = this.assetEndpoint().serverLogic((Function1 & Serializable)paths -> {
            String fullName = paths.mkString("/");
            Option option = config.deployment().locateAsset(fullName);
            if (None$.MODULE$.equals(option)) {
                return scala.package$.MODULE$.Left().apply((Object)new StatusCode(StatusCode$.MODULE$.NotFound()));
            }
            if (option instanceof Some) {
                Location value = (Location)((Some)option).value();
                return (Either)Using$.MODULE$.resource((Object)value.load(), (Function1 & Serializable)data -> {
                    byte[] bytes = data.readAllBytes();
                    return scala.package$.MODULE$.Right().apply((Object)ByteBuffer.wrap(bytes));
                }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            }
            throw new MatchError((Object)option);
        }, $less$colon$less$.MODULE$.refl());
        this.indexEndpoint = (Endpoint)((EndpointOutputsOps)((EndpointInputsOps)package$.MODULE$.endpoint().get()).in((EndpointInput)package$.MODULE$.stringToPath(""), ParamConcat$.MODULE$.concatUnitUnit())).out((EndpointOutput)package$.MODULE$.htmlBodyUtf8(), ParamConcat$.MODULE$.concatUnitLeft(TupleArity$.MODULE$.tupleArity1()));
        this.indexHandler = this.indexEndpoint().serverLogicSuccess((Function1 & Serializable)_$2 -> this.indexHtml, $less$colon$less$.MODULE$.refl());
        this.otherIndexEndpoint = (Endpoint)((EndpointOutputsOps)((EndpointInputsOps)package$.MODULE$.endpoint().get()).in((EndpointInput)package$.MODULE$.paths(), ParamConcat$.MODULE$.concatUnitLeft(TupleArity$.MODULE$.tupleArity1()))).out((EndpointOutput)package$.MODULE$.htmlBodyUtf8(), ParamConcat$.MODULE$.concatUnitLeft(TupleArity$.MODULE$.tupleArity1()));
        this.otherIndexHandler = this.otherIndexEndpoint().serverLogicSuccess((Function1 & Serializable)_$3 -> this.indexHtml, $less$colon$less$.MODULE$.refl());
        this.apiEndpointHandler = config.api().map((Function1 & Serializable)_$4 -> ApiHandler$.MODULE$.apply((Dispatcher<Object>)_$4).handler());
    }

    public Logger logger() {
        return this.logger;
    }

    public void run() {
        List endpoints = (List)((IterableOps)new .colon.colon((Object)this.assetHandler, (List)new .colon.colon((Object)this.indexHandler, (List)Nil$.MODULE$))).$plus$plus((IterableOnce)this.apiEndpointHandler().toList());
        List docEndpoints = SwaggerInterpreter$.MODULE$.apply(SwaggerInterpreter$.MODULE$.apply$default$1(), SwaggerInterpreter$.MODULE$.apply$default$2(), SwaggerInterpreter$.MODULE$.apply$default$3(), SwaggerInterpreter$.MODULE$.apply$default$4()).fromServerEndpoints(endpoints, "MiniServer", "0.1");
        NettySocketConfig socketConfig = NettySocketConfig$.MODULE$.default().withReuseAddress();
        this.logger().info(new StringBuilder(27).append("Will start on port ").append(this.config.port()).append(" (mode=").append(this.config.deployment().deploymentType()).append(")").toString());
        DeploymentType deploymentType = this.config.deployment().deploymentType();
        DeploymentType deploymentType2 = DeploymentType$.Debug;
        NettySyncServer$.MODULE$.apply().host(this.config.host()).port(this.config.port()).modifyConfig((Function1 & Serializable)_$1 -> _$1.socketConfig(socketConfig)).addEndpoints(endpoints).addEndpoints((List)(!(deploymentType != null ? !deploymentType.equals(deploymentType2) : deploymentType2 != null) ? docEndpoints : scala.package$.MODULE$.Nil())).addEndpoint(this.otherIndexHandler).startAndWait();
    }

    public Endpoint<BoxedUnit, List<String>, StatusCode, ByteBuffer, Object> assetEndpoint() {
        return this.assetEndpoint;
    }

    public Endpoint<BoxedUnit, BoxedUnit, BoxedUnit, String, Object> indexEndpoint() {
        return this.indexEndpoint;
    }

    public Endpoint<BoxedUnit, List<String>, BoxedUnit, String, Object> otherIndexEndpoint() {
        return this.otherIndexEndpoint;
    }

    public Option<ServerEndpoint> apiEndpointHandler() {
        return this.apiEndpointHandler;
    }
}

