/*
 * Decompiled with CFR 0.152.
 */
package net.redpipe.cdi;

import io.vertx.rxjava.core.Vertx;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Hashtable;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.Extension;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.NamingManager;
import javax.validation.ValidatorFactory;
import net.redpipe.engine.core.AppGlobals;
import net.redpipe.engine.spi.Plugin;
import net.redpipe.engine.spi.RunnableWithException;
import org.jboss.resteasy.cdi.CdiInjectorFactory;
import org.jboss.resteasy.cdi.ResteasyCdiExtension;
import org.jboss.resteasy.plugins.server.vertx.VertxResteasyDeployment;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.context.bound.BoundRequestContext;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.vertx.VertxExtension;
import rx.Single;

public class CdiPlugin
extends Plugin {
    private Weld weld;

    public Single<Void> init() {
        VertxExtension vertxExtension = (VertxExtension)CDI.current().select(VertxExtension.class, new Annotation[0]).get();
        BeanManager beanManager = CDI.current().getBeanManager();
        Vertx vertx = AppGlobals.get().getVertx();
        return vertx.rxExecuteBlocking(future -> {
            vertxExtension.registerConsumers(vertx.getDelegate(), BeanManagerProxy.unwrap((BeanManager)beanManager).event());
            future.complete();
        });
    }

    public Single<Void> deployToResteasy(VertxResteasyDeployment deployment) {
        ResteasyCdiExtension cdiExtension = (ResteasyCdiExtension)CDI.current().select(ResteasyCdiExtension.class, new Annotation[0]).get();
        deployment.setActualResourceClasses(cdiExtension.getResources());
        deployment.setInjectorFactoryClass(CdiInjectorFactory.class.getName());
        deployment.getActualProviderClasses().addAll(cdiExtension.getProviders());
        return Single.just(null);
    }

    public Single<Void> shutdown() {
        this.weld.shutdown();
        return super.shutdown();
    }

    public Single<Void> preInit() {
        this.weld = new Weld();
        this.weld.addExtension((Extension)new VertxExtension());
        this.weld.initialize();
        try {
            NamingManager.setInitialContextFactoryBuilder(new InitialContextFactoryBuilder(){

                @Override
                public InitialContextFactory createInitialContextFactory(Hashtable<?, ?> environment) throws NamingException {
                    return new InitialContextFactory(){

                        @Override
                        public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
                            InitialContext ctx = new InitialContext(){

                                @Override
                                public Object lookup(String name) throws NamingException {
                                    if (name.equals("java:comp/ValidatorFactory")) {
                                        return CDI.current().select(ValidatorFactory.class, new Annotation[0]).get();
                                    }
                                    return null;
                                }
                            };
                            return ctx;
                        }
                    };
                }
            });
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return Single.just(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aroundRequest(HttpRequest req, RunnableWithException<IOException> continuation) throws IOException {
        BoundRequestContext cdiContext = (BoundRequestContext)CDI.current().select(BoundRequestContext.class, new Annotation[0]).get();
        HashMap contextMap = new HashMap();
        cdiContext.associate(contextMap);
        cdiContext.activate();
        try {
            continuation.run();
        }
        finally {
            if (req.getAsyncContext().isSuspended()) {
                req.getAsyncContext().getAsyncResponse().register(t -> {
                    cdiContext.invalidate();
                    cdiContext.deactivate();
                    cdiContext.dissociate((Object)contextMap);
                });
            } else {
                cdiContext.invalidate();
                cdiContext.deactivate();
                cdiContext.dissociate(contextMap);
            }
        }
    }
}

