/*
 * Decompiled with CFR 0.152.
 */
package net.redpipe.example.kafka;

import io.debezium.kafka.KafkaCluster;
import io.debezium.util.Testing;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.rxjava.core.Vertx;
import io.vertx.rxjava.kafka.client.consumer.KafkaConsumer;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import net.redpipe.engine.core.AppGlobals;
import net.redpipe.engine.core.Server;
import net.redpipe.example.kafka.MetricsVerticle;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import rx.subjects.BehaviorSubject;

public class Main
extends Server {
    public static void main(String[] args) {
        new Server().start(new JsonObject().put("scan", new JsonArray().add(Main.class.getPackage().getName())), new Class[0]).subscribe(v -> Main.onStart(), x -> x.printStackTrace());
    }

    private static void onStart() {
        KafkaCluster kafkaCluster;
        System.err.println("Started");
        File dataDir = Testing.Files.createTestingDirectory((String)"cluster");
        dataDir.deleteOnExit();
        try {
            kafkaCluster = new KafkaCluster().usingDirectory(dataDir).withPorts(2181, 9092).addBrokers(1).deleteDataPriorToStartup(true).startup();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JsonObject consumerConfig = new JsonObject((Map)kafkaCluster.useTo().getConsumerProperties("the_group", "the_client", OffsetResetStrategy.LATEST));
        AppGlobals globals = AppGlobals.get();
        KafkaConsumer consumer = KafkaConsumer.create((Vertx)globals.getVertx(), (Map)consumerConfig.getMap(), String.class, JsonObject.class);
        BehaviorSubject consumerReporter = BehaviorSubject.create();
        consumer.toObservable().subscribe(record -> consumerReporter.onNext(record.value()));
        consumer.subscribe("the_topic");
        globals.setGlobal("consumer", (Object)consumerReporter);
        JsonObject producerConfig = new JsonObject((Map)kafkaCluster.useTo().getProducerProperties("the_producer"));
        globals.getVertx().deployVerticle(MetricsVerticle.class.getName(), new DeploymentOptions().setConfig(producerConfig).setInstances(3));
    }
}

