/*
 * Decompiled with CFR 0.152.
 */
package net.redpipe.example.kafka;

import com.sun.management.OperatingSystemMXBean;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.kafka.client.producer.KafkaWriteStream;
import io.vertx.rxjava.core.AbstractVerticle;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.UUID;
import org.apache.kafka.clients.producer.ProducerRecord;

public class MetricsVerticle
extends AbstractVerticle {
    private OperatingSystemMXBean systemMBean;
    private KafkaWriteStream<String, JsonObject> producer;

    public void start() throws Exception {
        this.systemMBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
        String pid = UUID.randomUUID().toString();
        JsonObject config = this.config();
        this.producer = KafkaWriteStream.create((Vertx)this.vertx.getDelegate(), (Map)config.getMap(), String.class, JsonObject.class);
        this.vertx.setPeriodic(1000L, id -> {
            JsonObject metrics = new JsonObject();
            metrics.put("CPU", Double.valueOf(this.systemMBean.getProcessCpuLoad()));
            metrics.put("Mem", Long.valueOf(this.systemMBean.getTotalPhysicalMemorySize() - this.systemMBean.getFreePhysicalMemorySize()));
            this.producer.write((Object)new ProducerRecord("the_topic", (Object)new JsonObject().put(pid, metrics)));
        });
    }

    public void stop() throws Exception {
        if (this.producer != null) {
            this.producer.close();
        }
    }
}

