/*
 * Decompiled with CFR 0.152.
 */
package net.revenj;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;
import java.util.UUID;
import net.revenj.storage.S3;
import net.revenj.storage.S3$;
import net.revenj.storage.S3Repository;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005]b\u0001\u0002\t\u0012\u0001YA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tY\u0001\u0011\t\u0011)A\u0005[!Aa\u0007\u0001B\u0001B\u0003%q\u0007C\u0003E\u0001\u0011\u0005Q\tC\u0004L\u0001\t\u0007I\u0011\u0002'\t\r5\u0003\u0001\u0015!\u00031\u0011\u001dq\u0005A1A\u0005\n=Ca\u0001\u0015\u0001!\u0002\u0013A\u0004bB)\u0001\u0005\u0004%IA\u0015\u0005\u00075\u0002\u0001\u000b\u0011B*\t\u000bm\u0003A\u0011\u0002/\t\u000b%\u0004A\u0011\t6\t\u000ba\u0004A\u0011I=\t\ra\u0004A\u0011IA\u0006\u0011\u001d\t9\u0003\u0001C!\u0003S\u0011!#Q7bu>t7k\r*fa>\u001c\u0018\u000e^8ss*\u0011!cE\u0001\u0007e\u00164XM\u001c6\u000b\u0003Q\t1A\\3u\u0007\u0001\u00192\u0001A\f\u001e!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0019\te.\u001f*fMB\u0011a$I\u0007\u0002?)\u0011\u0001%E\u0001\bgR|'/Y4f\u0013\t\u0011sD\u0001\u0007TgI+\u0007o\\:ji>\u0014\u00180\u0001\u0006qe>\u0004XM\u001d;jKN\u0004\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\tU$\u0018\u000e\u001c\u0006\u0002S\u0005!!.\u0019<b\u0013\tYcE\u0001\u0006Qe>\u0004XM\u001d;jKN\f1\u0003\u001e:z\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\u00042\u0001\u0007\u00181\u0013\ty\u0013D\u0001\u0004PaRLwN\u001c\t\u0003cQj\u0011A\r\u0006\u0003ge\t!bY8oGV\u0014(/\u001a8u\u0013\t)$G\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0006)AO]=TgA\u0019\u0001D\f\u001d\u0011\u0005e\u0012U\"\u0001\u001e\u000b\u0005mb\u0014AA:4\u0015\tid(\u0001\u0005tKJ4\u0018nY3t\u0015\ty\u0004)A\u0005b[\u0006TxN\\1xg*\t\u0011)A\u0002d_6L!a\u0011\u001e\u0003\u0011\u0005k\u0017M_8o'N\na\u0001P5oSRtD\u0003\u0002$I\u0013*\u0003\"a\u0012\u0001\u000e\u0003EAQa\t\u0003A\u0002\u0011BQ\u0001\f\u0003A\u00025BQA\u000e\u0003A\u0002]\n\u0001#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0016\u0003A\n\u0011#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;!\u0003!\u00198g\u00117jK:$X#\u0001\u001d\u0002\u0013M\u001c4\t\\5f]R\u0004\u0013A\u00032vG.,GOT1nKV\t1\u000bE\u0002\u0019]Q\u0003\"!\u0016-\u000e\u0003YS!a\u0016\u0015\u0002\t1\fgnZ\u0005\u00033Z\u0013aa\u0015;sS:<\u0017a\u00032vG.,GOT1nK\u0002\nQbZ3u\u0005V\u001c7.\u001a;OC6,GC\u0001+^\u0011\u0015q6\u00021\u0001`\u0003\u0011q\u0017-\\3\u0011\u0005\u0001<gBA1f!\t\u0011\u0017$D\u0001d\u0015\t!W#\u0001\u0004=e>|GOP\u0005\u0003Mf\ta\u0001\u0015:fI\u00164\u0017BA-i\u0015\t1\u0017$A\u0002hKR$2a\u001b;w!\r\tDN\\\u0005\u0003[J\u0012aAR;ukJ,\u0007CA8s\u001b\u0005\u0001(BA9)\u0003\tIw.\u0003\u0002ta\nY\u0011J\u001c9viN#(/Z1n\u0011\u0015)H\u00021\u0001`\u0003\u0019\u0011WoY6fi\")q\u000f\u0004a\u0001?\u0006\u00191.Z=\u0002\rU\u0004Hn\\1e)\u0011Qh0!\u0001\u0011\u0007Eb7\u0010\u0005\u0002\u001fy&\u0011Qp\b\u0002\u0003'NBQa`\u0007A\u00029\faa\u001d;sK\u0006l\u0007bBA\u0002\u001b\u0001\u0007\u0011QA\u0001\u0007Y\u0016tw\r\u001e5\u0011\u0007a\t9!C\u0002\u0002\ne\u0011A\u0001T8oORy!0!\u0004\u0002\u0010\u0005E\u00111CA\u000b\u00033\ti\u0002C\u0003v\u001d\u0001\u0007q\fC\u0003x\u001d\u0001\u0007q\fC\u0003\u0000\u001d\u0001\u0007a\u000eC\u0004\u0002\u00049\u0001\r!!\u0002\t\u0011ys\u0001\u0013!a\u0001\u0003/\u00012\u0001\u0007\u0018`\u0011%\tYB\u0004I\u0001\u0002\u0004\t9\"\u0001\u0005nS6,G+\u001f9f\u0011%\tyB\u0004I\u0001\u0002\u0004\t\t#\u0001\u0005nKR\fG-\u0019;b!\u0015\u0001\u00171E0`\u0013\r\t)\u0003\u001b\u0002\u0004\u001b\u0006\u0004\u0018A\u00023fY\u0016$X\r\u0006\u0004\u0002,\u0005M\u0012Q\u0007\t\u0005c1\fi\u0003E\u0002\u0019\u0003_I1!!\r\u001a\u0005\u0011)f.\u001b;\t\u000bU|\u0001\u0019A0\t\u000b]|\u0001\u0019A0")
public class AmazonS3Repository
implements S3Repository {
    private final Properties properties;
    private final ExecutionContext executionContext;
    private final AmazonS3 s3Client;
    private final Option<String> bucketName;

    @Override
    public Future<InputStream> get(S3 s3) {
        return S3Repository.get$(this, s3);
    }

    @Override
    public Option<String> upload$default$5() {
        return S3Repository.upload$default$5$(this);
    }

    @Override
    public Option<String> upload$default$6() {
        return S3Repository.upload$default$6$(this);
    }

    @Override
    public Map<String, String> upload$default$7() {
        return S3Repository.upload$default$7$(this);
    }

    @Override
    public Future<BoxedUnit> delete(S3 s3) {
        return S3Repository.delete$(this, s3);
    }

    private ExecutionContext executionContext() {
        return this.executionContext;
    }

    private AmazonS3 s3Client() {
        return this.s3Client;
    }

    private Option<String> bucketName() {
        return this.bucketName;
    }

    private String getBucketName(String name) {
        Some bn = name == null || name.isEmpty() ? this.bucketName() : new Some((Object)name);
        Predef$.MODULE$.require(bn.isDefined() && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)bn.get())), (Function0 & Serializable)() -> "Bucket name not specified for this S3 instance or system wide.\r\nEither specify revenj.s3-bucket-name in Properties as system wide name or provide a bucket name to this S3 instance");
        return (String)bn.get();
    }

    @Override
    public Future<InputStream> get(String bucket, String key) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> this.s3Client().getObject(bucket, key).getObjectContent(), this.executionContext());
    }

    @Override
    public Future<S3> upload(InputStream stream, long length) {
        String bn = this.getBucketName("");
        String key = UUID.randomUUID().toString();
        ObjectMetadata om = new ObjectMetadata();
        om.setContentLength(length);
        return Future$.MODULE$.apply((Function0 & Serializable)() -> {
            this.s3Client().putObject(new PutObjectRequest(bn, key, stream, om));
            return new S3(bn, key, length, S3$.MODULE$.apply$default$4(), S3$.MODULE$.apply$default$5(), S3$.MODULE$.apply$default$6());
        }, this.executionContext());
    }

    @Override
    public Future<S3> upload(String bucket, String key, InputStream stream, long length, Option<String> name, Option<String> mimeType, Map<String, String> metadata) {
        String bn = this.getBucketName(bucket);
        ObjectMetadata om = new ObjectMetadata();
        om.setContentLength(length);
        mimeType.foreach((Function1 & Serializable)x$1 -> {
            om.setContentType(x$1);
            return BoxedUnit.UNIT;
        });
        metadata.foreach((Function1 & Serializable)x0$1 -> {
            AmazonS3Repository.$anonfun$upload$3(om, x0$1);
            return BoxedUnit.UNIT;
        });
        return Future$.MODULE$.apply((Function0 & Serializable)() -> {
            this.s3Client().putObject(new PutObjectRequest(bn, key, stream, om));
            return new S3(bn, key, length, name, mimeType, metadata);
        }, this.executionContext());
    }

    @Override
    public Future<BoxedUnit> delete(String bucket, String key) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.s3Client().deleteObject(bucket, key), this.executionContext());
    }

    public static final /* synthetic */ void $anonfun$upload$3(ObjectMetadata om$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            om$2.addUserMetadata(k, v);
            return;
        }
        throw new MatchError(null);
    }

    public AmazonS3Repository(Properties properties, Option<ExecutionContext> tryExecutionContext, Option<AmazonS3> tryS3) {
        this.properties = properties;
        S3Repository.$init$(this);
        this.executionContext = (ExecutionContext)tryExecutionContext.getOrElse((Function0 & Serializable)() -> ExecutionContext$.MODULE$.global());
        this.s3Client = (AmazonS3)tryS3.getOrElse((Function0 & Serializable)() -> {
            Option s3AccessKey = Option$.MODULE$.apply((Object)$this.properties.getProperty("revenj.s3-user"));
            Option s3SecretKey = Option$.MODULE$.apply((Object)$this.properties.getProperty("revenj.s3-secret"));
            Option s3Region = Option$.MODULE$.apply((Object)$this.properties.getProperty("revenj.s3-region"));
            Predef$.MODULE$.require(s3AccessKey.isDefined() && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)s3AccessKey.get())), (Function0 & Serializable)() -> "S3 configuration is missing. Please add revenj.s3-user");
            Predef$.MODULE$.require(s3SecretKey.isDefined() && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)s3SecretKey.get())), (Function0 & Serializable)() -> "S3 configuration is missing. Please add revenj.s3-secret");
            AmazonS3ClientBuilder builder = AmazonS3Client.builder();
            builder.setCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials((String)s3AccessKey.get(), (String)s3SecretKey.get())));
            s3Region.foreach((Function1 & Serializable)x$1 -> {
                builder.setRegion(x$1);
                return BoxedUnit.UNIT;
            });
            return (AmazonS3)builder.build();
        });
        this.bucketName = Option$.MODULE$.apply((Object)properties.getProperty("revenj.s3-bucket-name"));
    }
}

